/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.bitbucketserver;

import com.oxygenxml.examples.authflow.GitCredentialsProvider;
import com.oxygenxml.examples.bitbucketserver.ProjectAndRepo;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.sync.basic.util.URLUtil;

public class BitbucketServerUrls {
    static final String API_URI = "/rest/api/1.0";
    private static final Pattern PROJECT_AND_REPO_PATTERN = Pattern.compile("./scm/([^/]+)/([^/]+).git");

    private BitbucketServerUrls() {
    }

    public static String getReadContentUrl(RepositoryLocation location) {
        String bitbucketServerUrl = GitCredentialsProvider.getBitbucketServerUrl();
        String projRepoUri = BitbucketServerUrls.getProjRepoUri(location.getRepositoryUri());
        String contentPath = GitUtil.encodePath(location.getPath());
        String rawApiEndpoint = "/raw/" + contentPath;
        String branch = location.getBranch();
        String branchUrlParameter = "at=" + URLUtil.encodeURIComponent((String)branch);
        String queryString = "?" + branchUrlParameter;
        String readContentUrl = bitbucketServerUrl + API_URI + projRepoUri + rawApiEndpoint + queryString;
        return readContentUrl;
    }

    public static String getUserInformationUrl() {
        String bitbucketServerUrl = GitCredentialsProvider.getBitbucketServerUrl();
        String usersApiEndpoint = "/users";
        String queryString = "?limit=1000";
        String userInformationUrl = bitbucketServerUrl + API_URI + usersApiEndpoint + queryString;
        return userInformationUrl;
    }

    public static String getUserRepositoriesUrl() {
        String bitbucketServerUrl = GitCredentialsProvider.getBitbucketServerUrl();
        String recentReposApiEndpoint = "/profile/recent/repos";
        String queryString = "?limit=1000";
        String userReposUrl = bitbucketServerUrl + API_URI + recentReposApiEndpoint + queryString;
        return userReposUrl;
    }

    public static String getCanPushInRepoUrl(String repositoryUri, String username) {
        String bitbucketServerUrl = GitCredentialsProvider.getBitbucketServerUrl();
        ProjectAndRepo projAndRepo = BitbucketServerUrls.extractProjAndRepo(repositoryUri);
        String usersApiEndpoint = "/users";
        String queryString = "?filter=" + URLUtil.encodeURIComponent((String)username) + "&permission=REPO_WRITE&permission.projectKey=" + URLUtil.encodeURIComponent((String)projAndRepo.getProjectKey()) + "&permission.repositorySlug=" + URLUtil.encodeURIComponent((String)projAndRepo.getRepositorySlug()) + "&limit=1000";
        String canPushInRepoUrl = bitbucketServerUrl + API_URI + usersApiEndpoint + queryString;
        return canPushInRepoUrl;
    }

    public static String getListFolderUrl(RepositoryLocation location) {
        String bitbucketServerUrl = GitCredentialsProvider.getBitbucketServerUrl();
        String projRepoUri = BitbucketServerUrls.getProjRepoUri(location.getRepositoryUri());
        String contentPath = GitUtil.encodePath(location.getPath());
        String filesApiEndpoint = "/files/" + contentPath;
        String branch = location.getBranch();
        String branchUrlParameter = "at=" + URLUtil.encodeURIComponent((String)branch);
        String queryString = "?" + branchUrlParameter + "&limit=100000";
        String listFolderUrl = bitbucketServerUrl + API_URI + projRepoUri + filesApiEndpoint + queryString;
        return listFolderUrl;
    }

    public static String getWriteContentUrl(RepositoryLocation location) {
        String bitbucketServerUrl = GitCredentialsProvider.getBitbucketServerUrl();
        String projRepoUri = BitbucketServerUrls.getProjRepoUri(location.getRepositoryUri());
        String contentPath = GitUtil.encodePath(location.getPath());
        String browseApiEndpoint = "/browse/" + contentPath;
        String writeContentUrl = bitbucketServerUrl + API_URI + projRepoUri + browseApiEndpoint;
        return writeContentUrl;
    }

    public static String getOpenPullRequestUrl(String repositoryUri) {
        String bitbucketServerUrl = GitCredentialsProvider.getBitbucketServerUrl();
        String projRepoUri = BitbucketServerUrls.getProjRepoUri(repositoryUri);
        String pullRequestsApiEndpoint = "/pull-requests";
        String openPullRequestUrl = bitbucketServerUrl + API_URI + projRepoUri + pullRequestsApiEndpoint;
        return openPullRequestUrl;
    }

    public static String getCommitsOfFileUrl(RepositoryLocation location) {
        String bitbucketServerUrl = GitCredentialsProvider.getBitbucketServerUrl();
        String projRepoUri = BitbucketServerUrls.getProjRepoUri(location.getRepositoryUri());
        String commitsApiEndpoint = "/commits";
        String query = "?until=" + URLUtil.encodeURIComponent((String)location.getBranch()) + "&path=" + URLUtil.encodeURIComponent((String)location.getPath()) + "&limit=10000";
        String commitsOfFileUrl = bitbucketServerUrl + API_URI + projRepoUri + commitsApiEndpoint + query;
        return commitsOfFileUrl;
    }

    static String getProjRepoUri(String repositoryUri) {
        String projRepoUri = "/projects/%s/repos/%s";
        ProjectAndRepo projAndRepo = BitbucketServerUrls.extractProjAndRepo(repositoryUri);
        return String.format(projRepoUri, URLUtil.encodeURIComponent((String)projAndRepo.getProjectKey()), URLUtil.encodeURIComponent((String)projAndRepo.getRepositorySlug()));
    }

    static ProjectAndRepo extractProjAndRepo(String repositoryUri) {
        Matcher projectAndRepoMatcher = PROJECT_AND_REPO_PATTERN.matcher(repositoryUri);
        if (projectAndRepoMatcher.find()) {
            String projectKey = projectAndRepoMatcher.group(1);
            String repositorySlug = projectAndRepoMatcher.group(2);
            return new ProjectAndRepo(projectKey, repositorySlug);
        }
        throw new IllegalArgumentException("The repositoryUri parameter must have the following format: {protocol}://{host}:{port}/scm/{projectKey}/{repositorySlug}.git");
    }
}

