/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.bitbucketserver;

import com.oxygenxml.examples.bitbucketserver.BitbucketServerApi;
import com.oxygenxml.examples.common.BaseUrlConnection;
import com.oxygenxml.examples.git.RESTGitAccess;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.List;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.plugin.urlstreamhandler.CacheableUrlConnection;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.net.protocol.FileBrowsingConnection;
import ro.sync.net.protocol.FolderEntryDescriptor;

public class BitbucketServerUrlConnection
extends BaseUrlConnection
implements FileBrowsingConnection,
CacheableUrlConnection {
    private RepositoryLocation location;
    private BitbucketServerApi bitbucketServerApi;

    public BitbucketServerUrlConnection(URLConnection delegateConnection, RepositoryLocation location, BitbucketServerApi bitbucketServerApi) {
        super(delegateConnection);
        this.location = location;
        this.bitbucketServerApi = bitbucketServerApi;
    }

    public List<FolderEntryDescriptor> listFolder() throws IOException {
        try {
            RepositoryLocation resolvedLocation = RESTGitAccess.submodulesResolver.resolveSubmodule(this.location, this.bitbucketServerApi);
            return this.bitbucketServerApi.listFolder(resolvedLocation);
        }
        catch (NotAuthorizedException e) {
            throw GitUtil.getNotAuthorizedAndNeedLoginEx();
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            RepositoryLocation resolvedLocation = RESTGitAccess.submodulesResolver.resolveSubmodule(this.location, this.bitbucketServerApi);
            return this.bitbucketServerApi.read(resolvedLocation);
        }
        catch (NotAuthorizedException e) {
            throw GitUtil.getNotAuthorizedAndNeedLoginEx();
        }
        catch (NotFoundException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                try {
                    RepositoryLocation resolvedLocation = RESTGitAccess.submodulesResolver.resolveSubmodule(BitbucketServerUrlConnection.this.location, BitbucketServerUrlConnection.this.bitbucketServerApi);
                    PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
                    String createdWithWebAuthMsg = rb.getMessage("Created_with_oxygen_web_author");
                    BitbucketServerUrlConnection.this.bitbucketServerApi.writeContent(resolvedLocation, this.toByteArray(), createdWithWebAuthMsg);
                }
                catch (NotAuthorizedException e) {
                    throw GitUtil.getNotAuthorizedAndNoLoginEx();
                }
            }
        };
    }
}

