/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.bitbucketserver;

import com.oxygenxml.examples.bitbucketserver.RepoBranch;
import com.oxygenxml.examples.bitbucketserver.paged.PagedApiResponse;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.webauthorgitapi.UserInformation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BitbucketServerApiResponseParser {
    private static final String VALUES = "values";

    private BitbucketServerApiResponseParser() {
    }

    public static String parseOAuthToken(InputStream response) {
        String responseString = GitUtil.utf8InputStreamToString(response);
        String oAuthTokenKeyValuePair = responseString.split("&")[0];
        int equalSignIndex = oAuthTokenKeyValuePair.indexOf(61);
        return oAuthTokenKeyValuePair.substring(equalSignIndex + 1);
    }

    public static UserInformation parseDisplayNameAndEmail(InputStream response, String userName) {
        String responseString = GitUtil.utf8InputStreamToString(response);
        Map<String, Object> parsedResponse = GitUtil.parseJSON(responseString);
        List users = (List)parsedResponse.get(VALUES);
        String uuid = null;
        String displayName = null;
        String email = null;
        for (Map user : users) {
            if (!((String)user.get("name")).equals(userName)) continue;
            displayName = (String)user.get("displayName");
            email = (String)user.get("emailAddress");
            uuid = (String)user.get("uuid");
            break;
        }
        return new UserInformation(uuid, displayName, email);
    }

    public static List<String> parseUserRepos(InputStream response) {
        String responseString = GitUtil.utf8InputStreamToString(response);
        Map<String, Object> parsedResponse = GitUtil.parseJSON(responseString);
        List repos = (List)parsedResponse.get(VALUES);
        ArrayList<String> userRepos = new ArrayList<String>();
        block0: for (Map repo : repos) {
            Map links = (Map)repo.get("links");
            List clone = (List)links.get("clone");
            for (Map method : clone) {
                if (!((String)method.get("name")).equals("http")) continue;
                String href = (String)method.get("href");
                userRepos.add(href);
                continue block0;
            }
        }
        return userRepos;
    }

    public static PagedApiResponse<RepoBranch> parseRepoBranches(InputStream response) {
        String responseString = GitUtil.utf8InputStreamToString(response);
        Map<String, Object> parsedResponse = GitUtil.parseJSON(responseString);
        boolean isLastPage = (Boolean)parsedResponse.get("isLastPage");
        Integer nextPageStart = (Integer)parsedResponse.get("nextPageStart");
        List branches = (List)parsedResponse.get(VALUES);
        ArrayList<RepoBranch> repoBranches = new ArrayList<RepoBranch>();
        for (Map branch : branches) {
            String branchName = (String)branch.get("displayId");
            String latestCommit = (String)branch.get("latestCommit");
            repoBranches.add(new RepoBranch(branchName, latestCommit));
        }
        return new PagedApiResponse<RepoBranch>(repoBranches, isLastPage, nextPageStart);
    }

    public static List<String> parseFiles(InputStream response, ApiResponseDetails responseDetails) {
        String responseString = GitUtil.utf8InputStreamToString(response);
        Map<String, Object> parsedResponse = GitUtil.parseJSON(responseString);
        responseDetails.isLastPage = (Boolean)parsedResponse.get("isLastPage");
        responseDetails.nextPageStart = (Integer)parsedResponse.get("nextPageStart");
        List files = (List)parsedResponse.get(VALUES);
        return files;
    }

    public static List<String> parseUsersWithPushPermission(InputStream response, ApiResponseDetails responseDetails) {
        String responseString = GitUtil.utf8InputStreamToString(response);
        Map<String, Object> parsedResponse = GitUtil.parseJSON(responseString);
        responseDetails.isLastPage = (Boolean)parsedResponse.get("isLastPage");
        responseDetails.nextPageStart = (Integer)parsedResponse.get("nextPageStart");
        List users = (List)parsedResponse.get(VALUES);
        ArrayList<String> userNames = new ArrayList<String>();
        for (Map user : users) {
            userNames.add((String)user.get("name"));
        }
        return userNames;
    }

    public static String parseCommitSha(InputStream response) {
        String responseString = GitUtil.utf8InputStreamToString(response);
        Map<String, Object> parsedResponse = GitUtil.parseJSON(responseString);
        String commitID = (String)parsedResponse.get("id");
        return commitID;
    }

    public static String parseOpenedPullRequestUrl(InputStream response) {
        String responseString = GitUtil.utf8InputStreamToString(response);
        Map<String, Object> parsedResponse = GitUtil.parseJSON(responseString);
        Map links = (Map)parsedResponse.get("links");
        Map firstLink = (Map)((List)links.get("self")).get(0);
        return (String)firstLink.get("href");
    }

    public static String parseFirstCommitSha(InputStream response) {
        String responseString = GitUtil.utf8InputStreamToString(response);
        Map<String, Object> parsedResponse = GitUtil.parseJSON(responseString);
        List commits = (List)parsedResponse.get(VALUES);
        Map firstCommit = (Map)commits.get(commits.size() - 1);
        return (String)firstCommit.get("id");
    }

    static class ApiResponseDetails {
        boolean isLastPage;
        Integer nextPageStart;

        ApiResponseDetails() {
        }
    }
}

