/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.bitbucketserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.examples.authflow.GitCredentialsProvider;
import com.oxygenxml.examples.bitbucket.MultiPartRequest;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerAccessToken;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerApiResponseParser;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerFile;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerUrls;
import com.oxygenxml.examples.bitbucketserver.ProjectAndRepo;
import com.oxygenxml.examples.bitbucketserver.RepoBranch;
import com.oxygenxml.examples.bitbucketserver.RepoBranchesUrlBuilder;
import com.oxygenxml.examples.bitbucketserver.ResourceNotFoundException;
import com.oxygenxml.examples.bitbucketserver.oauth.OAuthAuthorizationHeader;
import com.oxygenxml.examples.bitbucketserver.paged.PagedApiIterator;
import com.oxygenxml.examples.bitbucketserver.paged.PagedApiResponse;
import com.oxygenxml.examples.common.Functions;
import com.oxygenxml.examples.common.ThreeWayMerger;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.webauthorgitapi.DocumentToCommit;
import com.oxygenxml.examples.webauthorgitapi.GitDocumentInfo;
import com.oxygenxml.examples.webauthorgitapi.RepositoryBranch;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.UserInformation;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitApi;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.CommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.FailCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResult;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResultFail;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResultMerge;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResultOK;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.merge.MergeConflictResolutionMethods;
import ro.sync.merge.MergeResult;
import ro.sync.net.protocol.FolderEntryDescriptor;
import ro.sync.net.protocol.http.HttpExceptionWithDetails;

public class BitbucketServerApi
implements WebAuthorGitApi {
    private static final Logger log = LoggerFactory.getLogger(BitbucketServerApi.class);
    private static final String AUTHORIZATION = "Authorization";
    private BitbucketServerAccessToken accessToken;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();

    public BitbucketServerApi(BitbucketServerAccessToken accessToken) {
        this.accessToken = accessToken;
    }

    @Override
    public InputStream read(RepositoryLocation location) throws NotAuthorizedException, NotFoundException {
        try {
            String readContentUrl = BitbucketServerUrls.getReadContentUrl(location);
            InputStream content = this.sendHttpGetRequest(readContentUrl);
            return content;
        }
        catch (ResourceNotFoundException e) {
            throw new NotFoundException(location);
        }
        catch (HttpExceptionWithDetails e) {
            throw new UnexpectedException(this.parseErrorMessage(e.getReason()), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    @Override
    public String getContentAtCommit(RepositoryLocation location, String commitSha, String encoding) throws NotAuthorizedException, NotFoundException {
        String content;
        RepositoryLocation updatedLocation = new RepositoryLocation(location.getRepositoryUri(), commitSha, location.getPath());
        try (InputStream contentInputStream = this.read(updatedLocation);){
            content = GitUtil.inputStreamToString(contentInputStream, encoding);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        return content;
    }

    @Override
    public UserInformation getUserInformation() throws NotAuthorizedException {
        UserInformation userInformation;
        block9: {
            String filterQueryParam = "&filter=" + URLUtil.encodeURIComponent((String)this.accessToken.getUserName());
            String userInfoUrl = BitbucketServerUrls.getUserInformationUrl() + filterQueryParam;
            InputStream response = this.sendHttpGetRequest(userInfoUrl);
            try {
                userInformation = BitbucketServerApiResponseParser.parseDisplayNameAndEmail(response, this.accessToken.getUserName());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HttpExceptionWithDetails e) {
                    throw new UnexpectedException(this.parseErrorMessage(e.getReason()), e);
                }
                catch (IOException e) {
                    throw new UnexpectedException(e.getMessage(), e);
                }
            }
            response.close();
        }
        return userInformation;
    }

    @Override
    public List<String> getUserRepositories() throws NotAuthorizedException {
        try {
            List<String> userRepos;
            String userReposUrl = BitbucketServerUrls.getUserRepositoriesUrl();
            try (InputStream response = this.sendHttpGetRequest(userReposUrl);){
                userRepos = BitbucketServerApiResponseParser.parseUserRepos(response);
            }
            return userRepos;
        }
        catch (HttpExceptionWithDetails e) {
            throw new UnexpectedException(this.parseErrorMessage(e.getReason()), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> getRepoBranches(String repositoryUri) throws NotAuthorizedException {
        RepoBranchesUrlBuilder branchesUrlBuilder = new RepoBranchesUrlBuilder().repository(repositoryUri);
        PagedApiIterator<RepoBranch> stream = this.getRepoBranchesDetails(branchesUrlBuilder);
        ArrayList<String> allBranches = new ArrayList<String>();
        while (stream.hasNext()) {
            List branchNamesInBatch = stream.getNextBatch().stream().map(RepoBranch::getBranchName).collect(Collectors.toList());
            allBranches.addAll(branchNamesInBatch);
        }
        return allBranches;
    }

    public PagedApiIterator<RepoBranch> getRepoBranchesDetails(RepoBranchesUrlBuilder branchesUrlBuilder) throws NotAuthorizedException {
        return new PagedApiIterator<RepoBranch>(nextPageStart -> {
            PagedApiResponse<RepoBranch> pagedApiResponse;
            block9: {
                String repoBranchesUrl = branchesUrlBuilder.forRetrieval().fromOffset(nextPageStart).build();
                InputStream response = this.sendHttpGetRequest(repoBranchesUrl);
                try {
                    pagedApiResponse = BitbucketServerApiResponseParser.parseRepoBranches(response);
                    if (response == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (HttpExceptionWithDetails e) {
                        throw new UnexpectedException(this.parseErrorMessage(e.getReason()), e);
                    }
                    catch (IOException e) {
                        throw new UnexpectedException(e.getMessage(), e);
                    }
                }
                response.close();
            }
            return pagedApiResponse;
        });
    }

    @Override
    public List<FolderEntryDescriptor> listFolder(RepositoryLocation location) throws NotAuthorizedException {
        try {
            ArrayList<FolderEntryDescriptor> folderEntryDescriptors = new ArrayList<FolderEntryDescriptor>();
            HashSet<String> folderEntries = new HashSet<String>();
            String baseListFolderUrl = BitbucketServerUrls.getListFolderUrl(location);
            BitbucketServerApiResponseParser.ApiResponseDetails responseDetails = new BitbucketServerApiResponseParser.ApiResponseDetails();
            while (!responseDetails.isLastPage) {
                List<String> partialFiles;
                Object listFolderUrl = baseListFolderUrl;
                if (responseDetails.nextPageStart != null) {
                    listFolderUrl = (String)listFolderUrl + "&start=" + responseDetails.nextPageStart;
                }
                try (InputStream response = this.sendHttpGetRequest((String)listFolderUrl);){
                    partialFiles = BitbucketServerApiResponseParser.parseFiles(response, responseDetails);
                }
                folderEntries.addAll(this.filesToFolderEntries(partialFiles, location.getPath()));
            }
            for (String folderEntry : folderEntries) {
                folderEntryDescriptors.add(new FolderEntryDescriptor(folderEntry));
            }
            return folderEntryDescriptors;
        }
        catch (HttpExceptionWithDetails e) {
            throw new UnexpectedException(this.parseErrorMessage(e.getReason()), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private Set<String> filesToFolderEntries(List<String> files, String basePath) {
        HashSet<String> folderEntries = new HashSet<String>();
        for (String file : files) {
            int slashIndex = file.indexOf(47);
            if (slashIndex != -1) {
                file = file.substring(0, slashIndex + 1);
            }
            folderEntries.add(GitUtil.encodePath(basePath + "/" + file));
        }
        return folderEntries;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canPushInRepository(String repositoryUri) throws NotAuthorizedException {
        try {
            String baseCanPushInRepoUrl = BitbucketServerUrls.getCanPushInRepoUrl(repositoryUri, this.accessToken.getUserName());
            BitbucketServerApiResponseParser.ApiResponseDetails responseDetails = new BitbucketServerApiResponseParser.ApiResponseDetails();
            while (!responseDetails.isLastPage) {
                Object canPushInRepoUrl = baseCanPushInRepoUrl;
                if (responseDetails.nextPageStart != null) {
                    canPushInRepoUrl = (String)canPushInRepoUrl + "&start=" + responseDetails.nextPageStart;
                }
                InputStream response = this.sendHttpGetRequest((String)canPushInRepoUrl);
                try {
                    List<String> usersWithPushPermission = BitbucketServerApiResponseParser.parseUsersWithPushPermission(response, responseDetails);
                    if (!usersWithPushPermission.contains(this.accessToken.getUserName())) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            return false;
        }
        catch (HttpExceptionWithDetails e) {
            throw new UnexpectedException(this.parseErrorMessage(e.getReason()), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean canPushOnBranch(String repositoryUri, String branch) throws NotAuthorizedException {
        return true;
    }

    @Override
    public String createFork(String repositoryUri) throws NotAuthorizedException {
        throw new IllegalStateException("The Bitbucket Server connector does not support forking.");
    }

    @Override
    public GitDocumentInfo getDocument(RepositoryLocation location) throws NotAuthorizedException, NotFoundException {
        String content;
        String branchTipSha = this.getBranchTipSha(location.getRepositoryBranch()).orElseThrow(() -> new NotFoundException(location));
        try (InputStream is = this.read(location);){
            content = GitUtil.utf8InputStreamToString(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        String contentSha = Functions.toGitSha1(content);
        GitDocumentInfo documentInfo = new GitDocumentInfo(content, contentSha, branchTipSha);
        return documentInfo;
    }

    @Override
    public CommitResult write(RepositoryLocation location, String content, String message) throws NotAuthorizedException, NotFoundException {
        CommitResult commitResult;
        block9: {
            InputStream response = this.read(location);
            try {
                GitDocumentInfo docInfo = this.getDocument(location);
                commitResult = this.commit(location, content, message, docInfo);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NotFoundException e) {
                    return this.commit(location, content, message, null);
                }
                catch (IOException e) {
                    throw new UnexpectedException(e.getMessage(), e);
                }
            }
            response.close();
        }
        return commitResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(RepositoryLocation location, byte[] content, String message) throws IOException, NotAuthorizedException {
        String writeContentUrl = BitbucketServerUrls.getWriteContentUrl(location);
        URL url = new URL(writeContentUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            conn.setDoOutput(true);
            String requestMethod = "PUT";
            conn.setRequestMethod(requestMethod);
            conn.setRequestProperty(AUTHORIZATION, this.getAuthorizationHeader(requestMethod, url));
            String boundary = "----" + System.currentTimeMillis() + "----";
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            String branchName = location.getBranch();
            String createdWithWAMsg = rb.getMessage("Created_with_oxygen_web_author");
            GitDocumentInfo docInfo = null;
            try {
                docInfo = this.getDocument(location);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
                MultiPartRequest request = new MultiPartRequest(wr, boundary);
                request.writeField("content", content);
                request.writeField("branch", branchName);
                request.writeField("message", createdWithWAMsg);
                System.out.println("docInfo: " + docInfo);
                if (docInfo != null) {
                    request.writeField("sourceCommitId", docInfo.getCommitSha());
                }
                request.endMessage();
                wr.flush();
            }
            catch (HttpExceptionWithDetails e) {
                int reasonCode = e.getReasonCode();
                if (reasonCode == 401 || reasonCode == 403) {
                    throw new NotAuthorizedException(e);
                }
                throw e;
            }
        }
        finally {
            conn.disconnect();
        }
    }

    @Override
    public CommitResult commit(RepositoryLocation location, String content, String message, GitDocumentInfo docInfo) throws NotAuthorizedException, NotFoundException {
        try {
            String fileSha;
            String commitSha;
            String writeContentUrl = BitbucketServerUrls.getWriteContentUrl(location);
            String boundary = "----" + System.currentTimeMillis() + "----";
            StringBuilder body = new StringBuilder();
            Functions.addFormData(body, "content", content, boundary);
            Functions.addFormData(body, "branch", location.getBranch(), boundary);
            Functions.addFormData(body, "message", message, boundary);
            if (docInfo != null) {
                Functions.addFormData(body, "sourceCommitId", docInfo.getCommitSha(), boundary);
            }
            body.append("--" + boundary + "--\r\n");
            String bodyString = body.toString();
            try (InputStream response = this.sendHttpPostOrPutRequest("PUT", writeContentUrl, boundary, bodyString);){
                commitSha = BitbucketServerApiResponseParser.parseCommitSha(response);
                fileSha = Functions.toGitSha1(content);
            }
            return new CommitResultOK(commitSha, fileSha);
        }
        catch (ResourceNotFoundException e) {
            throw new NotFoundException(location);
        }
        catch (HttpExceptionWithDetails e) {
            if (docInfo == null) {
                log.error("Failed to create new file in " + location + ", with response from Bitbucket: " + e.getReason());
            }
            if (e.getReasonCode() == 409 && docInfo != null) {
                GitDocumentInfo latestDocInfo = this.getDocument(location);
                if (content.equals(latestDocInfo.getContent())) {
                    String identicalContentError = "The content provided is the same as what already exists. No change was committed.";
                    return new CommitResultFail(identicalContentError);
                }
                MergeResult mergeResult = this.mergeStrings(docInfo.getContent(), content, latestDocInfo.getContent());
                return new CommitResultMerge(mergeResult, latestDocInfo.getCommitSha());
            }
            if (e.getReasonCode() == 500 && e.getReason().contains("the target ref was updated mid-merge")) {
                return this.commit(location, content, message, docInfo);
            }
            return new CommitResultFail(this.parseErrorMessage(e.getReason()));
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    @Override
    public CommitOperationResult commitDocuments(List<DocumentToCommit> documents, String repositoryUri, String branch, String latestCommitSha, String commitMessage, boolean forcePush) {
        CommitResult commitResult = null;
        ArrayList<DocumentToCommit> committedDocuments = new ArrayList<DocumentToCommit>();
        for (DocumentToCommit document : documents) {
            try {
                commitResult = this.commitDocument(document, branch, latestCommitSha, commitMessage);
            }
            catch (NotAuthorizedException | NotFoundException | IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                return new FailCommitOperationResult(Functions.getExceptionStatus(e), e.getMessage(), committedDocuments);
            }
            if (commitResult.isSuccessful()) {
                committedDocuments.add(document);
                continue;
            }
            return commitResult.intoCommitOperationResult(committedDocuments);
        }
        if (commitResult != null) {
            return commitResult.intoCommitOperationResult(committedDocuments);
        }
        String emptyCommitMessage = rb.getMessage("EMPTY_COMMIT_");
        return new FailCommitOperationResult(409, emptyCommitMessage, committedDocuments);
    }

    private CommitResult commitDocument(DocumentToCommit document, String branch, String latestCommitSha, String commitMessage) throws NotAuthorizedException, NotFoundException, IOException {
        BitbucketServerFile latestFileVersion = this.getLatestFileVersion(document);
        RepositoryLocation location = document.getLocation();
        RepositoryLocation updatedLocation = new RepositoryLocation(location.getRepositoryUri(), branch, location.getPath());
        String encoding = document.getEncoding();
        String initialContent = this.getContentAtCommitOrContentAtCreation(location, latestCommitSha, encoding);
        String initialContentSha = Functions.toGitSha1(initialContent);
        String contentToCommit = new String(document.getContentToCommit(), encoding);
        String latestContent = latestFileVersion.getContent();
        String lastCommitId = latestFileVersion.getLastCommitId();
        if (!initialContent.equals(latestContent) && branch.equals(document.getLocation().getBranch())) {
            MergeResult mergeResult = this.mergeStrings(initialContent, contentToCommit, latestContent);
            return new CommitResultMerge(mergeResult, lastCommitId);
        }
        GitDocumentInfo docInfo = new GitDocumentInfo(initialContent, initialContentSha, lastCommitId);
        return this.commit(updatedLocation, contentToCommit, commitMessage, docInfo);
    }

    private BitbucketServerFile getLatestFileVersion(DocumentToCommit document) throws NotAuthorizedException, NotFoundException, IOException {
        String content;
        RepositoryLocation location = document.getLocation();
        String lastCommitId = this.getBranchTipSha(location.getRepositoryBranch()).orElseThrow(() -> new NotFoundException(location));
        RepositoryLocation updatedLocation = new RepositoryLocation(location.getRepositoryUri(), lastCommitId, location.getPath());
        try (InputStream response = this.read(updatedLocation);){
            content = GitUtil.inputStreamToString(response, document.getEncoding());
        }
        return new BitbucketServerFile(location, content, lastCommitId);
    }

    @VisibleForTesting
    Optional<String> getBranchTipSha(RepositoryBranch location) throws NotAuthorizedException, NotFoundException {
        RepoBranchesUrlBuilder branchesUrlBuilder = new RepoBranchesUrlBuilder().repository(location.getRepositoryUri()).withFilterText(location.getBranch());
        PagedApiIterator<RepoBranch> stream = this.getRepoBranchesDetails(branchesUrlBuilder);
        while (stream.hasNext()) {
            Optional<RepoBranch> branchDetails = stream.getNextBatch().stream().filter(repoBranch -> repoBranch.getBranchName().equals(location.getBranch())).findFirst();
            if (!branchDetails.isPresent()) continue;
            return Optional.of(branchDetails.get().getKnownBranchTipCommitSha());
        }
        return Optional.empty();
    }

    MergeResult mergeStrings(String ancestor, String left, String right) {
        ThreeWayMerger merger = new ThreeWayMerger();
        return merger.merge(ancestor, left, right, MergeConflictResolutionMethods.USE_LEFT);
    }

    @Override
    public void createBranch(String repositoryUri, String newBranch, String sourceRepositoryUri, String sourceBranch) throws NotAuthorizedException {
        if (!repositoryUri.equals(sourceRepositoryUri)) {
            throw new UnexpectedException("The repositoryUri and sourceRepositoryUri parameters must be the same.");
        }
        try {
            String createBranchUrl = new RepoBranchesUrlBuilder().repository(repositoryUri).build();
            String body = "{\"name\": " + OBJECT_MAPPER.writeValueAsString((Object)newBranch) + ",\"startPoint\": " + OBJECT_MAPPER.writeValueAsString((Object)sourceBranch) + "}";
            InputStream response = this.sendHttpPostOrPutRequest("POST", createBranchUrl, null, body);
            if (response != null) {
                response.close();
            }
        }
        catch (HttpExceptionWithDetails e) {
            throw new UnexpectedException(this.parseErrorMessage(e.getReason()), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    @Override
    public String openPullRequest(String sourceRepositoryUri, String destinationRepositoryUri, String sourceBranch, String destinationBranch, String pullRequestMessage, String pullRequestTitle) throws NotAuthorizedException {
        try {
            String openedPullRequestUrl;
            String openPullRequestUrl = BitbucketServerUrls.getOpenPullRequestUrl(sourceRepositoryUri);
            ProjectAndRepo projAndRepoSource = BitbucketServerUrls.extractProjAndRepo(sourceRepositoryUri);
            ProjectAndRepo projAndRepoDest = BitbucketServerUrls.extractProjAndRepo(destinationRepositoryUri);
            String body = "{\"title\": " + OBJECT_MAPPER.writeValueAsString((Object)pullRequestTitle) + ",\"description\": " + OBJECT_MAPPER.writeValueAsString((Object)pullRequestMessage) + ",\"state\": \"OPEN\",\"open\": true,\"fromRef\": {\"id\": " + OBJECT_MAPPER.writeValueAsString((Object)sourceBranch) + ",\"repository\": {\"slug\": " + OBJECT_MAPPER.writeValueAsString((Object)projAndRepoSource.getRepositorySlug()) + ",\"project\": {\"key\": " + OBJECT_MAPPER.writeValueAsString((Object)projAndRepoSource.getProjectKey()) + "}}},\"toRef\": {\"id\": " + OBJECT_MAPPER.writeValueAsString((Object)destinationBranch) + ",\"repository\": {\"slug\": " + OBJECT_MAPPER.writeValueAsString((Object)projAndRepoDest.getRepositorySlug()) + ",\"project\": {\"key\": " + OBJECT_MAPPER.writeValueAsString((Object)projAndRepoDest.getProjectKey()) + "}}},\"locked\": false}";
            try (InputStream response = this.sendHttpPostOrPutRequest("POST", openPullRequestUrl, null, body);){
                openedPullRequestUrl = BitbucketServerApiResponseParser.parseOpenedPullRequestUrl(response);
            }
            return openedPullRequestUrl;
        }
        catch (HttpExceptionWithDetails e) {
            int reasonCode = e.getReasonCode();
            if (reasonCode == 401 || reasonCode == 403) {
                throw new NotAuthorizedException(e);
            }
            throw new UnexpectedException(this.parseErrorMessage(e.getReason()), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    @Override
    public String getShaOfCommitThatCreatedDocument(RepositoryLocation location) throws NotAuthorizedException, NotFoundException {
        try {
            String shaOfCommitThatCreatedDocument;
            String commitsOfFileUrl = BitbucketServerUrls.getCommitsOfFileUrl(location);
            try (InputStream response = this.sendHttpGetRequest(commitsOfFileUrl);){
                shaOfCommitThatCreatedDocument = BitbucketServerApiResponseParser.parseFirstCommitSha(response);
            }
            return shaOfCommitThatCreatedDocument;
        }
        catch (ResourceNotFoundException e) {
            throw new NotFoundException(location);
        }
        catch (HttpExceptionWithDetails e) {
            throw new UnexpectedException(this.parseErrorMessage(e.getReason()), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private InputStream sendHttpGetRequest(String urlString) throws NotAuthorizedException, IOException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty(AUTHORIZATION, this.getAuthorizationHeader("GET", url));
        try {
            return conn.getInputStream();
        }
        catch (HttpExceptionWithDetails e) {
            int reasonCode = e.getReasonCode();
            if (reasonCode == 401 || reasonCode == 403) {
                throw new NotAuthorizedException(e);
            }
            if (reasonCode == 404) {
                throw new ResourceNotFoundException();
            }
            if (reasonCode == 500) {
                String reason = e.getReason();
                if (reason != null && reason.contains("does not exist in")) {
                    throw new ResourceNotFoundException();
                }
                throw e;
            }
            throw e;
        }
    }

    private InputStream sendHttpPostOrPutRequest(String requestMethod, String urlString, String boundary, String body) throws NotAuthorizedException, IOException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(requestMethod);
        conn.setRequestProperty(AUTHORIZATION, this.getAuthorizationHeader(requestMethod, url));
        if (requestMethod.equals("POST")) {
            conn.setRequestProperty("Content-Type", "application/json");
        } else {
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        }
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        conn.setRequestProperty("Content-Length", Integer.toString(bytes.length));
        conn.setDoOutput(true);
        try (OutputStream outputStream = conn.getOutputStream();){
            outputStream.write(bytes);
        }
        catch (HttpExceptionWithDetails e) {
            conn.disconnect();
            int reasonCode = e.getReasonCode();
            if (reasonCode == 401 || reasonCode == 403) {
                throw new NotAuthorizedException(e);
            }
            if (reasonCode == 404) {
                throw new ResourceNotFoundException();
            }
            throw e;
        }
        return conn.getInputStream();
    }

    private String getAuthorizationHeader(String requestMethod, URL requestUrl) {
        Object authorizationHeader = null;
        String accessTokenString = this.accessToken.getAccessToken();
        if (accessTokenString.startsWith("<oxy>")) {
            accessTokenString = accessTokenString.substring("<oxy>".length());
            String username = this.accessToken.getUserName();
            authorizationHeader = "Basic " + Functions.encodeCredentials(username, accessTokenString);
        } else {
            OAuthAuthorizationHeader oAuthAuthorizationHeader = new OAuthAuthorizationHeader(requestMethod, requestUrl, GitCredentialsProvider.getBitbucketServerConsumerKey(), GitCredentialsProvider.getBitbucketServerPrivateKey(), this.accessToken.getAccessToken(), null);
            authorizationHeader = oAuthAuthorizationHeader.getContent();
        }
        return authorizationHeader;
    }

    private String parseErrorMessage(String reason) {
        List errors = (List)GitUtil.parseJSON(reason).get("errors");
        Map error = (Map)errors.get(0);
        if (error.get("details") != null) {
            return (String)((List)error.get("details")).get(0);
        }
        return (String)error.get("message");
    }
}

