/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.bitbucket;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class UserNameAndRepo {
    private final String userName;
    private final String repo;

    private UserNameAndRepo(String userName, String repo) {
        this.userName = userName;
        this.repo = repo;
    }

    public static UserNameAndRepo from(String repositoryUri) {
        String userNameAndRepoRegex = "^https?://(?:www\\.)?bitbucket.org/([^/]+)/([^/]+)";
        Pattern userNameAndRepoPattern = Pattern.compile(userNameAndRepoRegex);
        Matcher matcher = userNameAndRepoPattern.matcher(repositoryUri);
        if (matcher.find()) {
            return new UserNameAndRepo(matcher.group(1), matcher.group(2));
        }
        throw new IllegalArgumentException("Invalid repositoryUri: " + repositoryUri);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRepo() {
        return this.repo;
    }
}

