/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.bitbucket;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class MultiPartRequest {
    private static final String TWO_HYPHENS = "--";
    private static final String CRLF = "\r\n";
    private DataOutputStream wr;
    private String boundary;

    public MultiPartRequest(DataOutputStream wr, String boundary) {
        this.wr = wr;
        this.boundary = boundary;
    }

    public void writeFileContent(byte[] content, String path) throws IOException {
        this.writeBoundary();
        this.wr.writeBytes("Content-Disposition: form-data; name=\"" + path + "\";filename=\"" + path + "\"\r\n");
        this.wr.writeBytes(CRLF);
        this.wr.write(content);
        this.wr.writeBytes(CRLF);
    }

    public void endMessage() throws IOException {
        this.wr.writeBytes(TWO_HYPHENS + this.boundary + "--\r\n");
    }

    public void writeField(String name, String value) throws IOException {
        this.writeField(name, value.getBytes(StandardCharsets.UTF_8));
    }

    public void writeField(String name, byte[] bytes) throws IOException {
        this.writeBoundary();
        this.wr.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"\r\n");
        this.wr.writeBytes(CRLF);
        this.wr.write(bytes, 0, bytes.length);
        this.wr.writeBytes(CRLF);
    }

    private void writeBoundary() throws IOException {
        this.wr.writeBytes(TWO_HYPHENS + this.boundary + CRLF);
    }
}

