/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.bitbucket;

import com.oxygenxml.examples.bitbucket.BitbucketApi;
import com.oxygenxml.examples.common.BaseUrlConnection;
import com.oxygenxml.examples.git.RESTGitAccess;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.List;
import ro.sync.net.protocol.FolderEntryDescriptor;

public class BitbucketUrlConnection
extends BaseUrlConnection {
    private RepositoryLocation location;
    private BitbucketApi bitbucketApi;

    public BitbucketUrlConnection(URLConnection delegateConnection, RepositoryLocation location, BitbucketApi bitbucketApi) {
        super(delegateConnection);
        this.location = location;
        this.bitbucketApi = bitbucketApi;
    }

    public InputStream getInputStream() throws IOException {
        try {
            RepositoryLocation resolvedLocation = RESTGitAccess.submodulesResolver.resolveSubmodule(this.location, this.bitbucketApi);
            return this.bitbucketApi.read(resolvedLocation);
        }
        catch (NotAuthorizedException e) {
            throw GitUtil.getNotAuthorizedAndNeedLoginEx();
        }
        catch (NotFoundException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                try {
                    RepositoryLocation resolvedLocation = RESTGitAccess.submodulesResolver.resolveSubmodule(BitbucketUrlConnection.this.location, BitbucketUrlConnection.this.bitbucketApi);
                    BitbucketUrlConnection.this.bitbucketApi.writeContent(resolvedLocation, this.toByteArray());
                }
                catch (NotAuthorizedException e) {
                    throw GitUtil.getNotAuthorizedAndNoLoginEx();
                }
            }
        };
    }

    public List<FolderEntryDescriptor> listFolder() throws IOException {
        try {
            RepositoryLocation resolvedLocation = RESTGitAccess.submodulesResolver.resolveSubmodule(this.location, this.bitbucketApi);
            return this.bitbucketApi.listFolder(resolvedLocation);
        }
        catch (NotAuthorizedException e) {
            throw GitUtil.getNotAuthorizedAndNeedLoginEx();
        }
    }
}

