/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.bitbucket;

import com.oxygenxml.examples.authflow.CredentialTypes;
import com.oxygenxml.examples.authflow.GitCredentialsProvider;
import com.oxygenxml.examples.bitbucket.BitbucketAccessToken;
import com.oxygenxml.examples.bitbucket.BitbucketOauthDispatcher;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.oauther.OAuthService;
import com.oxygenxml.examples.oauther.OAuthState;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import ro.sync.basic.io.QuietClosable;
import ro.sync.net.protocol.http.HttpExceptionWithDetails;

public class BitbucketOAuthService
implements OAuthService<BitbucketAccessToken> {
    @Override
    public String getAuthorizationUrl(OAuthState state) {
        String clientId = GitCredentialsProvider.getBitbucketClientId();
        return "https://bitbucket.org/site/oauth2/authorize?client_id=" + clientId + "&response_type=code&state=" + state.getCode();
    }

    public static void tryAccess(String sessionId, BitbucketAccessToken accessToken, CheckedFunction method) throws IOException, NotAuthorizedException {
        try {
            try {
                method.call(accessToken);
            }
            catch (HttpExceptionWithDetails e) {
                if (e.getReasonCode() == 401) {
                    BitbucketAccessToken refreshedAccessToken = BitbucketOauthDispatcher.service.refreshAccessToken(accessToken);
                    GitCredentialsProvider.setCredentials(sessionId, CredentialTypes.BITBUCKET, refreshedAccessToken);
                    method.call(refreshedAccessToken);
                    return;
                }
                throw e;
            }
        }
        catch (HttpExceptionWithDetails e) {
            int statusCode = e.getReasonCode();
            if (statusCode == 401 || e.getReason() != null && e.getReason().contains("You're not allowed to write to this repository")) {
                throw new NotAuthorizedException(e);
            }
            throw e;
        }
    }

    @Override
    public BitbucketAccessToken extractAccessToken(String code) {
        try {
            String[] accessRefresh = this.getAccessToken(code);
            String username = this.getUsername(accessRefresh[0]);
            return new BitbucketAccessToken(accessRefresh[0], accessRefresh[1], username);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getAccessToken(String code) throws IOException {
        String clientId = GitCredentialsProvider.getBitbucketClientId();
        String clientSecret = GitCredentialsProvider.getBitbucketClientSecret();
        URL url = new URL("https://bitbucket.org/site/oauth2/access_token");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            String githubResponseBody;
            String requestBody = "grant_type=authorization_code&code=" + code;
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Authorization", "Basic " + this.encodeCredentials(clientId, clientSecret));
            conn.setRequestProperty("Content-Length", "" + requestBody.length());
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            try (OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());){
                writer.write(requestBody);
            }
            try (InputStream inputStream = QuietClosable.from((InputStream)conn.getInputStream());){
                githubResponseBody = GitUtil.utf8InputStreamToString(inputStream);
            }
            Map<String, Object> tokenInfo = GitUtil.parseJSON(githubResponseBody);
            String[] ret = new String[]{(String)tokenInfo.get("access_token"), (String)tokenInfo.get("refresh_token")};
            String[] stringArray = ret;
            return stringArray;
        }
        finally {
            conn.disconnect();
        }
    }

    private String getUsername(String accessToken) throws IOException {
        if (accessToken.contains("<oxy>")) {
            return accessToken.split("<oxy>")[0];
        }
        URL url = new URL("https://api.bitbucket.org/2.0/user");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Authorization", "Bearer " + accessToken);
        try (InputStream inputStream = QuietClosable.from((InputStream)conn.getInputStream());){
            String githubResponseBody = GitUtil.utf8InputStreamToString(inputStream);
            Map<String, Object> userInfo = GitUtil.parseJSON(githubResponseBody);
            String username = (String)userInfo.get("username");
            if (username == null || username.isEmpty()) {
                throw new IOException("Could not retrieve username");
            }
            String string = username;
            return string;
        }
    }

    private String encodeCredentials(String clientId, String clientSecret) {
        byte[] unencodedConsumerAuth = (clientId + ":" + clientSecret).getBytes(StandardCharsets.UTF_8);
        byte[] encodedConsumerAuth = Base64.getEncoder().encode(unencodedConsumerAuth);
        return new String(encodedConsumerAuth, StandardCharsets.UTF_8);
    }

    @Override
    public BitbucketAccessToken refreshAccessToken(BitbucketAccessToken accessToken) {
        String refreshToken = null;
        if (accessToken != null) {
            refreshToken = accessToken.getRefreshToken();
        }
        if (refreshToken == null) {
            return null;
        }
        try {
            String[] accessRefresh = this.getAccessTokenFromRefresh(refreshToken);
            String username = this.getUsername(accessRefresh[0]);
            return new BitbucketAccessToken(accessRefresh[0], accessRefresh[1], username);
        }
        catch (HttpExceptionWithDetails e) {
            if (e.getReasonCode() == 401) {
                return null;
            }
            throw new UnexpectedException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getAccessTokenFromRefresh(String refreshToken) throws IOException {
        String clientId = GitCredentialsProvider.getBitbucketClientId();
        String clientSecret = GitCredentialsProvider.getBitbucketClientSecret();
        URL url = new URL("https://bitbucket.org/site/oauth2/access_token");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            String githubResponseBody;
            String requestBody = "grant_type=refresh_token&refresh_token=" + refreshToken;
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Authorization", "Basic " + this.encodeCredentials(clientId, clientSecret));
            conn.setRequestProperty("Content-Length", "" + requestBody.length());
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            try (OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());){
                writer.write(requestBody);
            }
            try (InputStream inputStream = QuietClosable.from((InputStream)conn.getInputStream());){
                githubResponseBody = GitUtil.utf8InputStreamToString(inputStream);
            }
            Map<String, Object> tokenInfo = GitUtil.parseJSON(githubResponseBody);
            String[] ret = new String[]{(String)tokenInfo.get("access_token"), (String)tokenInfo.get("refresh_token")};
            String[] stringArray = ret;
            return stringArray;
        }
        finally {
            conn.disconnect();
        }
    }

    @Override
    public void onAccessTokenReceived(BitbucketAccessToken accessToken, String sessionId, OAuthState state) {
        GitCredentialsProvider.setCredentials(sessionId, CredentialTypes.BITBUCKET, accessToken);
    }

    @Override
    public void onAccessTokenRefreshed(BitbucketAccessToken accessToken, String sessionId) {
        GitCredentialsProvider.setCredentials(sessionId, CredentialTypes.BITBUCKET, accessToken);
    }

    @Override
    public BitbucketAccessToken toAccessTokenType(String accessToken) {
        try {
            return new BitbucketAccessToken(accessToken, null, this.getUsername(accessToken));
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    @FunctionalInterface
    public static interface CheckedFunction {
        public void call(BitbucketAccessToken var1) throws IOException, NotAuthorizedException;
    }
}

