/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.bitbucket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.examples.bitbucket.BitbucketAccessToken;
import com.oxygenxml.examples.bitbucket.BitbucketOAuthService;
import com.oxygenxml.examples.bitbucket.MultiPartRequest;
import com.oxygenxml.examples.bitbucket.UserNameAndRepo;
import com.oxygenxml.examples.common.Functions;
import com.oxygenxml.examples.git.GitAccess;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.webauthorgitapi.DocumentToCommit;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitApi;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.CommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.FailCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.MergeCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.OkCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.net.protocol.FolderEntryDescriptor;
import ro.sync.net.protocol.http.HttpExceptionWithDetails;

public class BitbucketApi
implements WebAuthorGitApi {
    private static final Logger log = LoggerFactory.getLogger(BitbucketApi.class);
    private static final String AUTHORIZATION = "Authorization";
    private static final String BASE_API_URI = "https://api.bitbucket.org/2.0/repositories/";
    private static final String SRC = "/src/";
    private final BitbucketAccessToken accessToken;
    private final String sessionId;
    private final GitAccess jGitAccess;

    public BitbucketApi(String sessionId, BitbucketAccessToken accessToken, GitAccess jGitAccess) {
        this.sessionId = sessionId;
        this.accessToken = accessToken;
        this.jGitAccess = jGitAccess;
    }

    @Override
    public InputStream read(RepositoryLocation location) throws NotAuthorizedException, NotFoundException {
        String repositoryUri = location.getRepositoryUri();
        UserNameAndRepo userNameAndRepo = UserNameAndRepo.from(repositoryUri);
        String username = userNameAndRepo.getUserName();
        String repo = userNameAndRepo.getRepo();
        try {
            String branch = location.getBranch();
            if (branch.contains("/")) {
                branch = this.getBitbucketBranchHash(username, repo, branch);
            }
            URL contentUrl = new URL(BASE_API_URI + username + "/" + repo + SRC + branch + "/" + GitUtil.encodePath(location.getPath()));
            AtomicReference<Object> ret = new AtomicReference<Object>(null);
            BitbucketOAuthService.tryAccess(this.sessionId, this.accessToken, token -> {
                HttpURLConnection conn = (HttpURLConnection)contentUrl.openConnection();
                if (token != null) {
                    conn.setRequestProperty(AUTHORIZATION, this.getAuthorizationHeader(token));
                }
                ret.set(conn.getInputStream());
            });
            return ret.get();
        }
        catch (HttpExceptionWithDetails e) {
            if (e.getReasonCode() == 404) {
                throw new NotFoundException(location);
            }
            throw new UnexpectedException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    public void writeContent(RepositoryLocation location, byte[] content) throws IOException, NotAuthorizedException {
        String repositoryUri = location.getRepositoryUri();
        UserNameAndRepo userNameAndRepo = UserNameAndRepo.from(repositoryUri);
        String username = userNameAndRepo.getUserName();
        String repo = userNameAndRepo.getRepo();
        URL commitUrl = new URL(BASE_API_URI + username + "/" + repo + "/src");
        PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
        String createdWithWAMsg = rb.getMessage("Created_with_oxygen_web_author");
        String branchName = location.getBranch();
        String path = location.getPath();
        BitbucketOAuthService.tryAccess(this.sessionId, this.accessToken, currentAccessToken -> {
            block18: {
                HttpURLConnection conn = (HttpURLConnection)commitUrl.openConnection();
                try {
                    conn.setDoOutput(true);
                    conn.setRequestMethod("POST");
                    if (currentAccessToken != null) {
                        conn.setRequestProperty(AUTHORIZATION, this.getAuthorizationHeader(currentAccessToken));
                    }
                    String boundary = UUID.randomUUID().toString();
                    conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
                    try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
                        MultiPartRequest request = new MultiPartRequest(wr, boundary);
                        request.writeFileContent(content, path);
                        request.writeField("branch", branchName);
                        request.writeField("message", createdWithWAMsg);
                        request.endMessage();
                        wr.flush();
                    }
                    catch (HttpExceptionWithDetails e) {
                        String reason = e.getReason();
                        log.debug("Failed to write file " + location + ", reason " + reason);
                        if (reason.contains("Something went wrong") || reason.contains("Access denied.") || reason.contains("make sure you are authenticated")) {
                            throw new NotAuthorizedException(e);
                        }
                        throw e;
                    }
                    if (conn.getResponseCode() == 201) break block18;
                    InputStream stream = conn.getErrorStream();
                    try {
                        throw new IOException("Failed to create file on Bitbucket repository: " + GitUtil.utf8InputStreamToString(stream));
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                finally {
                    conn.disconnect();
                }
            }
        });
    }

    private IOException createExceptionForServerResponse(HttpURLConnection conn) {
        try {
            return new IOException(conn.getResponseCode() + " - " + GitUtil.utf8InputStreamToString(conn.getErrorStream()));
        }
        catch (IOException e) {
            return e;
        }
    }

    @Override
    public List<FolderEntryDescriptor> listFolder(RepositoryLocation location) throws NotAuthorizedException {
        String repositoryUri = location.getRepositoryUri();
        UserNameAndRepo userNameAndRepo = UserNameAndRepo.from(repositoryUri);
        String username = userNameAndRepo.getUserName();
        String repo = userNameAndRepo.getRepo();
        String branch = location.getBranch();
        String path = location.getPath();
        try {
            if (branch.contains("/")) {
                branch = this.getBitbucketBranchHash(username, repo, branch);
            }
            Stream<Map<Object, Object>> filesStream = this.isFolder(username, repo, branch, path) ? this.listFolder(username, repo, branch, path) : Stream.empty();
            return filesStream.map(file -> {
                Object filePath = (String)file.get("path");
                String type = (String)file.get("type");
                List attributes = (List)file.get("attributes");
                if ("commit_directory".equals(type) || attributes.contains("subrepository")) {
                    filePath = (String)filePath + "/";
                }
                return new FolderEntryDescriptor(GitUtil.encodePath((String)filePath));
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private Stream<Map<String, Object>> listFolder(String username, String repo, String branch, String path) throws IOException, NotAuthorizedException {
        Stream<Map<String, Object>> soFar = Stream.empty();
        URL url = new URL(BASE_API_URI + username + "/" + repo + SRC + branch + "/" + GitUtil.encodePath(path) + "/?fields=next,values.path,values.type,values.attributes");
        boolean done = false;
        int currentPage = 1;
        while (!done) {
            int responseCode;
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            if (this.accessToken != null) {
                conn.setRequestProperty(AUTHORIZATION, this.getAuthorizationHeader(this.accessToken));
            }
            if ((responseCode = conn.getResponseCode()) == 200) {
                String responseText;
                try (InputStream inputStream = conn.getInputStream();){
                    responseText = GitUtil.utf8InputStreamToString(inputStream);
                }
                Map<String, Object> responseBody = GitUtil.parseJSON(responseText);
                List responseFiles = (List)responseBody.get("values");
                soFar = Stream.of(soFar, responseFiles.stream()).flatMap(s -> s);
                String next = (String)responseBody.get("next");
                if (next != null && !next.isEmpty()) {
                    ++currentPage;
                    url = new URL(next);
                    continue;
                }
                done = true;
                continue;
            }
            if (currentPage == 1) {
                if (responseCode == 401 || responseCode == 403) {
                    throw new NotAuthorizedException(new IOException("Status: " + responseCode));
                }
                InputStream errorStream = conn.getErrorStream();
                try {
                    throw new UnexpectedException("listFolder: " + GitUtil.utf8InputStreamToString(errorStream));
                }
                catch (Throwable throwable) {
                    if (errorStream != null) {
                        try {
                            errorStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            log.warn("Retrieved " + (currentPage - 1) + " pages of results while listing BitBucket folder. Received an error at the " + currentPage + "th page. Error stream: \n" + GitUtil.utf8InputStreamToString(conn.getErrorStream()));
            done = true;
        }
        return soFar;
    }

    @VisibleForTesting
    String getBitbucketBranchHash(String username, String repo, String branch) throws NotAuthorizedException, IOException {
        URL url = new URL(BASE_API_URI + username + "/" + repo + "/refs/branches/" + branch + "?fields=target.hash");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            int responseCode;
            if (this.accessToken != null) {
                conn.setRequestProperty(AUTHORIZATION, this.getAuthorizationHeader(this.accessToken));
            }
            if ((responseCode = conn.getResponseCode()) == 200) {
                try (InputStream inputStream = conn.getInputStream();){
                    String responseText = GitUtil.utf8InputStreamToString(inputStream);
                    Map<String, Object> responseBody = GitUtil.parseJSON(responseText);
                    HashMap target = (HashMap)responseBody.get("target");
                    String string = (String)target.get("hash");
                    return string;
                }
            }
            if (responseCode == 401 || responseCode == 403) {
                throw new NotAuthorizedException(this.createExceptionForServerResponse(conn));
            }
            throw new UnexpectedException("getBitbucketBranchHash: " + GitUtil.utf8InputStreamToString(conn.getErrorStream()));
        }
        finally {
            conn.disconnect();
        }
    }

    private String getAuthorizationHeader(BitbucketAccessToken accessToken) {
        String authorizationHeader;
        String accessTokenString = accessToken.getAccessToken();
        if (accessTokenString.contains("<oxy>")) {
            String[] userToken = accessTokenString.split("<oxy>");
            authorizationHeader = "Basic " + Functions.encodeCredentials(userToken[0], userToken[1]);
        } else {
            authorizationHeader = "Bearer " + accessTokenString;
        }
        return authorizationHeader;
    }

    private boolean isFolder(String username, String repo, String branch, String path) throws NotAuthorizedException, IOException {
        int responseCode;
        URL url = new URL(BASE_API_URI + username + "/" + repo + SRC + branch + "/" + GitUtil.encodePath(path) + "?format=meta&fields=type,commit.hash");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (this.accessToken != null) {
            conn.setRequestProperty(AUTHORIZATION, this.getAuthorizationHeader(this.accessToken));
        }
        if ((responseCode = conn.getResponseCode()) == 200) {
            try (InputStream inputStream = conn.getInputStream();){
                String responseText = GitUtil.utf8InputStreamToString(inputStream);
                Map<String, Object> responseBody = GitUtil.parseJSON(responseText);
                String type = (String)responseBody.get("type");
                boolean bl = "commit_directory".equals(type);
                return bl;
            }
        }
        if (responseCode == 401 || responseCode == 403) {
            throw new NotAuthorizedException(this.createExceptionForServerResponse(conn));
        }
        throw new UnexpectedException("isFolder: " + GitUtil.utf8InputStreamToString(conn.getErrorStream()));
    }

    @Override
    public String getContentAtCommit(RepositoryLocation location, String commitSha, String encoding) throws NotAuthorizedException, NotFoundException {
        String repositoryUri = location.getRepositoryUri();
        UserNameAndRepo userNameAndRepo = UserNameAndRepo.from(repositoryUri);
        String userName = userNameAndRepo.getUserName();
        String repo = userNameAndRepo.getRepo();
        try {
            URL contentUrl = new URL(BASE_API_URI + userName + "/" + repo + SRC + commitSha + "/" + GitUtil.encodePath(location.getPath()));
            AtomicReference<Object> ret = new AtomicReference<Object>(null);
            BitbucketOAuthService.tryAccess(this.sessionId, this.accessToken, token -> {
                HttpURLConnection conn = (HttpURLConnection)contentUrl.openConnection();
                if (token != null) {
                    conn.setRequestProperty(AUTHORIZATION, this.getAuthorizationHeader(token));
                }
                try (InputStream is = conn.getInputStream();){
                    ret.set(GitUtil.inputStreamToString(is, encoding));
                }
            });
            return ret.get();
        }
        catch (HttpExceptionWithDetails e) {
            if (e.getReasonCode() == 404) {
                throw new NotFoundException(location);
            }
            throw new UnexpectedException(e.getReason(), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    @Override
    public void createBranch(String repositoryUri, String newBranch, String sourceRepositoryUri, String sourceBranch) throws NotAuthorizedException {
        if (!repositoryUri.equals(sourceRepositoryUri)) {
            this.jGitAccess.createBranch(repositoryUri, newBranch, sourceRepositoryUri, sourceBranch);
            return;
        }
        UserNameAndRepo userNameAndRepo = UserNameAndRepo.from(repositoryUri);
        String userName = userNameAndRepo.getUserName();
        String repo = userNameAndRepo.getRepo();
        UserNameAndRepo userNameAndRepoSource = UserNameAndRepo.from(sourceRepositoryUri);
        String userNameSource = userNameAndRepoSource.getUserName();
        String repoSource = userNameAndRepoSource.getRepo();
        try {
            URL createBranchUrl = new URL(BASE_API_URI + userName + "/" + repo + "/refs/branches");
            BitbucketOAuthService.tryAccess(this.sessionId, this.accessToken, token -> {
                HttpURLConnection conn = (HttpURLConnection)createBranchUrl.openConnection();
                try {
                    if (token != null) {
                        conn.setRequestProperty(AUTHORIZATION, this.getAuthorizationHeader(token));
                    }
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Content-Type", "application/json");
                    conn.setDoOutput(true);
                    StringBuilder body = new StringBuilder();
                    body.append("{\"name\":").append(new ObjectMapper().writeValueAsString((Object)newBranch));
                    body.append(",\"target\":{\"hash\":\"");
                    body.append(this.getBitbucketBranchHash(userNameSource, repoSource, sourceBranch)).append("\"}}");
                    try (DataOutputStream writer = new DataOutputStream(conn.getOutputStream());){
                        writer.writeBytes(body.toString());
                    }
                    InputStream response = conn.getInputStream();
                    if (response != null) {
                        response.close();
                    }
                }
                finally {
                    conn.disconnect();
                }
            });
        }
        catch (HttpExceptionWithDetails e) {
            throw new UnexpectedException(e.getReason(), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    @Override
    public CommitOperationResult commitDocuments(List<DocumentToCommit> documents, String repositoryUri, String branch, String latestCommitSha, String commitMessage, boolean forcePush) {
        UserNameAndRepo userNameAndRepo = UserNameAndRepo.from(repositoryUri);
        String userName = userNameAndRepo.getUserName();
        String repo = userNameAndRepo.getRepo();
        try {
            String headSha = this.getBitbucketBranchHash(userName, repo, branch);
            if (!headSha.equals(latestCommitSha) && !forcePush) {
                return new MergeCommitOperationResult(false, headSha, null);
            }
            URL commitUrl = new URL(BASE_API_URI + userName + "/" + repo + "/src");
            BitbucketOAuthService.tryAccess(this.sessionId, this.accessToken, token -> {
                HttpURLConnection conn = (HttpURLConnection)commitUrl.openConnection();
                try {
                    if (token != null) {
                        conn.setRequestProperty(AUTHORIZATION, this.getAuthorizationHeader(token));
                    }
                    conn.setRequestMethod("POST");
                    String boundary = "----" + System.currentTimeMillis() + "----";
                    conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                    conn.setDoOutput(true);
                    String data = this.buildCommitData(documents, branch, latestCommitSha, commitMessage, forcePush, boundary);
                    try (DataOutputStream writer = new DataOutputStream(conn.getOutputStream());){
                        writer.writeBytes(data);
                    }
                    InputStream response = conn.getInputStream();
                    if (response != null) {
                        response.close();
                    }
                }
                finally {
                    conn.disconnect();
                }
            });
            headSha = this.getBitbucketBranchHash(userName, repo, branch);
            return new OkCommitOperationResult(headSha, documents);
        }
        catch (HttpExceptionWithDetails e) {
            if (e.getReason().contains("is not the head of branch")) {
                try {
                    String headSha = this.getBitbucketBranchHash(userName, repo, branch);
                    return new MergeCommitOperationResult(false, headSha, null);
                }
                catch (NotAuthorizedException | IOException e1) {
                    return new FailCommitOperationResult(Functions.getExceptionStatus(e1), e1.getMessage());
                }
            }
            return new FailCommitOperationResult(e.getReasonCode(), e.getReason());
        }
        catch (NotAuthorizedException | IOException e) {
            return new FailCommitOperationResult(Functions.getExceptionStatus(e), e.getMessage());
        }
    }

    @Override
    public String getShaOfCommitThatCreatedDocument(RepositoryLocation location) throws NotAuthorizedException, NotFoundException {
        UserNameAndRepo userNameAndRepo = UserNameAndRepo.from(location.getRepositoryUri());
        String userName = userNameAndRepo.getUserName();
        String repo = userNameAndRepo.getRepo();
        try {
            URL commitsUrl = new URL(BASE_API_URI + userName + "/" + repo + "/commits/" + URLUtil.encodeURIComponent((String)location.getBranch()) + "?path=" + URLUtil.encodeURIComponent((String)location.getPath()));
            AtomicReference<Object> ret = new AtomicReference<Object>(null);
            BitbucketOAuthService.tryAccess(this.sessionId, this.accessToken, token -> {
                String responseString;
                HttpURLConnection conn = (HttpURLConnection)commitsUrl.openConnection();
                if (token != null) {
                    conn.setRequestProperty(AUTHORIZATION, this.getAuthorizationHeader(token));
                }
                try (InputStream response = conn.getInputStream();){
                    responseString = GitUtil.utf8InputStreamToString(response);
                }
                Map<String, Object> commits = GitUtil.parseJSON(responseString);
                List commitsValues = (List)commits.get("values");
                ret.set(((String)((Map)commitsValues.get(commitsValues.size() - 1)).get("hash")));
            });
            return ret.get();
        }
        catch (HttpExceptionWithDetails e) {
            if (e.getReasonCode() == 404) {
                throw new NotFoundException(location);
            }
            throw new UnexpectedException(e.getReason(), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private String buildCommitData(List<DocumentToCommit> documents, String branch, String latestCommitSha, String commitMessage, boolean forcePush, String boundary) {
        StringBuilder data = new StringBuilder();
        String crlf = "\r\n";
        for (DocumentToCommit document : documents) {
            String path = document.getLocation().getPath();
            data.append("--").append(boundary).append(crlf);
            data.append("Content-Transfer-Encoding: base64").append(crlf);
            data.append("Content-Disposition: form-data; name=\"").append(path).append("\"").append(crlf);
            data.append(crlf);
            data.append(Base64.encodeBase64String((byte[])document.getContentToCommit())).append(crlf);
        }
        Functions.addFormData(data, "branch", branch, boundary);
        Functions.addFormData(data, "message", commitMessage, boundary);
        if (!forcePush) {
            Functions.addFormData(data, "parents", latestCommitSha, boundary);
        }
        data.append("--").append(boundary).append("--").append(crlf);
        return data.toString();
    }
}

