/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.authflow;

import com.oxygenxml.examples.authflow.CredentialTypes;
import com.oxygenxml.examples.authflow.UserPassEmailCredentialsProvider;
import com.oxygenxml.examples.bitbucket.BitbucketAccessToken;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerAccessToken;
import com.oxygenxml.examples.gitlab.GitlabAccessToken;
import ro.sync.ecss.extensions.api.webapp.SessionStore;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class GitCredentialsProvider {
    public static final String GITLAB_API_URL = "https://gitlab.com";
    private static final String GIT_ENFORCED_USER = "git.enforced_user";
    private static final String GIT_ENFORCED_PASS = "git.enforced_pass";
    private static final String GIT_ENFORCED_MAIL = "git.enforced_mail";
    private static String gitGenericDisabled;
    private static String gitResolveSubmodule;
    private static String gitlabClientId;
    private static String gitlabClientSecret;
    private static String gitlabRetrieveStrategy;
    private static String gitlabEnterpriseClientId;
    private static String gitlabEnterpriseClientSecret;
    private static String gitlabEnterpriseApiUrl;
    private static String gitlabRedirectUri;
    private static String gitlabEnterpriseRedirectUri;
    private static String gitlabEnterpiseVersion;
    private static String gitlabEnterpriseRetrieveStrategy;
    private static String bitbucketClientId;
    private static String bitbucketClientSecret;
    private static String bitbucketRetrieveStrategy;
    private static String githubApiUrl;
    private static String githubClientId;
    private static String gitHubClientSecret;
    private static String githubRetrieveStrategy;
    private static volatile Integer gitlabApiVersion;
    private static volatile Integer gitlabEnterpriseApiVersion;
    private static String bitbucketServerUrl;
    private static String bitbucketServerConsumerKey;
    private static String bitbucketServerPrivateKey;
    private static String bitbucketServerPublicKey;
    private static String bitbucketServerRetrieveStrategy;

    private GitCredentialsProvider() {
    }

    private static SessionStore getSessionStore() {
        WebappPluginWorkspace workspace = (WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        return workspace.getSessionStore();
    }

    private static String getCredentialKey(CredentialTypes type) {
        return "git.crdls." + type.name();
    }

    public static String getGitlabClientId() {
        return gitlabClientId;
    }

    public static String isGitGenericDisabled() {
        return gitGenericDisabled;
    }

    public static void setGitGenericDisabled(String gitGenericDisabled) {
        GitCredentialsProvider.gitGenericDisabled = gitGenericDisabled;
    }

    public static String isGitResolveSubmodules() {
        return gitResolveSubmodule;
    }

    public static void setGitResolveSubmodules(String gitResolveSubmodule) {
        GitCredentialsProvider.gitResolveSubmodule = gitResolveSubmodule;
    }

    public static void setGitlabClientId(String gitlabClientId) {
        GitCredentialsProvider.gitlabClientId = gitlabClientId;
    }

    public static String getGitlabClientSecret() {
        return PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().decrypt(gitlabClientSecret);
    }

    public static void setGitlabClientSecret(String gitlabClientSecret) {
        GitCredentialsProvider.gitlabClientSecret = gitlabClientSecret = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt(gitlabClientSecret);
    }

    public static void setGitlabRetrieveStrategy(String gitlabRetrieveStrategy) {
        GitCredentialsProvider.gitlabRetrieveStrategy = gitlabRetrieveStrategy;
    }

    public static String getGitlabRetrieveStrategy() {
        return gitlabRetrieveStrategy;
    }

    public static boolean isGitlabHybridRetrieveStrategy() {
        return "hybrid".equals(gitlabRetrieveStrategy);
    }

    public static String getGitlabEnterpriseClientId() {
        return gitlabEnterpriseClientId;
    }

    public static void setGitlabEnterpriseClientId(String gitlabEnterpriseClientId) {
        GitCredentialsProvider.gitlabEnterpriseClientId = gitlabEnterpriseClientId;
    }

    public static String getGitlabEnterpriseClientSecret() {
        return PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().decrypt(gitlabEnterpriseClientSecret);
    }

    public static void setGitlabEnterpriseClientSecret(String gitlabEnterpriseClientSecret) {
        GitCredentialsProvider.gitlabEnterpriseClientSecret = gitlabEnterpriseClientSecret = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt(gitlabEnterpriseClientSecret);
    }

    public static String getGitlabEnterpriseApiUrl() {
        String gitlabEApiUrl = gitlabEnterpriseApiUrl;
        if (gitlabEApiUrl != null && gitlabEApiUrl.endsWith("/")) {
            gitlabEApiUrl = gitlabEApiUrl.substring(0, gitlabEApiUrl.length() - 1);
        }
        return gitlabEApiUrl;
    }

    public static void setGitlabEnterpriseApiUrl(String gitlabEnterpriseApiUrl) {
        GitCredentialsProvider.gitlabEnterpriseApiUrl = gitlabEnterpriseApiUrl;
        gitlabApiVersion = null;
    }

    public static String getGitlabRedirectUri() {
        return gitlabRedirectUri;
    }

    public static void setGitlabRedirectUri(String gitlabRedirectUri) {
        GitCredentialsProvider.gitlabRedirectUri = gitlabRedirectUri;
    }

    public static String getGitlabEnterpriseRedirectUri() {
        return gitlabEnterpriseRedirectUri;
    }

    public static void setGitlabEnterpriseRedirectUri(String gitlabEnterpriseRedirectUri) {
        GitCredentialsProvider.gitlabEnterpriseRedirectUri = gitlabEnterpriseRedirectUri;
    }

    public static String getGitlabEnterpiseVersion() {
        return gitlabEnterpiseVersion;
    }

    public static void setGitlabEnterpiseVersion(String gitlabEnterpiseVersion) {
        GitCredentialsProvider.gitlabEnterpiseVersion = gitlabEnterpiseVersion;
    }

    public static void setGitlabEnterpriseRetrieveStrategy(String gitlabEnterpriseRetrieveStrategy) {
        GitCredentialsProvider.gitlabEnterpriseRetrieveStrategy = gitlabEnterpriseRetrieveStrategy;
    }

    public static String getGitlabEnterpriseRetrieveStrategy() {
        return gitlabEnterpriseRetrieveStrategy;
    }

    public static boolean isGitlabEnterpriseHybridRetrieveStrategy() {
        return "hybrid".equals(gitlabEnterpriseRetrieveStrategy);
    }

    public static String getBitbucketClientId() {
        return bitbucketClientId;
    }

    public static void setBitbucketClientId(String bitbucketClientId) {
        GitCredentialsProvider.bitbucketClientId = bitbucketClientId;
    }

    public static String getBitbucketClientSecret() {
        return PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().decrypt(bitbucketClientSecret);
    }

    public static void setBitbucketClientSecret(String bitbucketClientSecret) {
        GitCredentialsProvider.bitbucketClientSecret = bitbucketClientSecret = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt(bitbucketClientSecret);
    }

    public static void setBitbucketRetrieveStrategy(String bitbucketRetrieveStrategy) {
        GitCredentialsProvider.bitbucketRetrieveStrategy = bitbucketRetrieveStrategy;
    }

    public static String getBitbucketRetrieveStrategy() {
        return bitbucketRetrieveStrategy;
    }

    public static boolean isBitbucketHybridRetrieveStrategy() {
        return "hybrid".equals(bitbucketRetrieveStrategy);
    }

    public static String getGitHubApiUrl() {
        String ghApiUrl = githubApiUrl;
        if (ghApiUrl != null && ghApiUrl.endsWith("/")) {
            ghApiUrl = ghApiUrl.substring(0, ghApiUrl.length() - 1);
        }
        return ghApiUrl;
    }

    public static void setGitHubApiUrl(String gitHubApiUrl) {
        githubApiUrl = gitHubApiUrl;
    }

    public static void setGithubRetrieveStrategy(String githubRetrieveStrategy) {
        GitCredentialsProvider.githubRetrieveStrategy = githubRetrieveStrategy;
    }

    public static String getGithubRetrieveStrategy() {
        return githubRetrieveStrategy;
    }

    public static boolean isGithubHybridRetrieveStrategy() {
        return "hybrid".equals(githubRetrieveStrategy);
    }

    public static String getGitHubClientId() {
        return githubClientId;
    }

    public static void setGitHubClientId(String gitHubClientId) {
        githubClientId = gitHubClientId;
    }

    public static String getGitHubClientSecret() {
        return PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().decrypt(gitHubClientSecret);
    }

    public static void setGitHubClientSecret(String gitHubClientSecret) {
        GitCredentialsProvider.gitHubClientSecret = gitHubClientSecret = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt(gitHubClientSecret);
    }

    public static String getBitbucketServerUrl() {
        return bitbucketServerUrl;
    }

    public static void setBitbucketServerUrl(String bitbucketServerUrl) {
        if (bitbucketServerUrl != null && bitbucketServerUrl.endsWith("/")) {
            bitbucketServerUrl = bitbucketServerUrl.substring(0, bitbucketServerUrl.length() - 1);
        }
        GitCredentialsProvider.bitbucketServerUrl = bitbucketServerUrl;
    }

    public static String getBitbucketServerConsumerKey() {
        return bitbucketServerConsumerKey;
    }

    public static void setBitbucketServerConsumerKey(String bitbucketServerConsumerKey) {
        GitCredentialsProvider.bitbucketServerConsumerKey = bitbucketServerConsumerKey;
    }

    public static String getBitbucketServerPrivateKey() {
        return PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().decrypt(bitbucketServerPrivateKey);
    }

    public static void setBitbucketServerPrivateKey(String bitbucketServerPrivateKey) {
        GitCredentialsProvider.bitbucketServerPrivateKey = bitbucketServerPrivateKey = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt(bitbucketServerPrivateKey);
    }

    public static String getBitbucketServerPublicKey() {
        return PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().decrypt(bitbucketServerPublicKey);
    }

    public static void setBitbucketServerPublicKey(String bitbucketServerPublicKey) {
        GitCredentialsProvider.bitbucketServerPublicKey = bitbucketServerPublicKey = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt(bitbucketServerPublicKey);
    }

    public static void setBitbucketServerRetrieveStrategy(String bitbucketServerRetrieveStrategy) {
        GitCredentialsProvider.bitbucketServerRetrieveStrategy = bitbucketServerRetrieveStrategy;
    }

    public static String getBitbucketServerRetrieveStrategy() {
        return bitbucketServerRetrieveStrategy;
    }

    public static boolean isBitbucketServerHybridRetrieveStrategy() {
        return "hybrid".equals(bitbucketServerRetrieveStrategy);
    }

    public static Object getAccessToken(String contextId, CredentialTypes credentialType) {
        Object token = GitCredentialsProvider.getSessionStore().get(contextId, GitCredentialsProvider.getCredentialKey(credentialType));
        if (token != null && token instanceof String) {
            token = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().decrypt((String)token);
        }
        return token;
    }

    public static UserPassEmailCredentialsProvider getCredentials(String contextId, CredentialTypes credentialType) {
        String gitEnforcedUser;
        if (credentialType == CredentialTypes.USERPASS && (gitEnforcedUser = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption(GIT_ENFORCED_USER, null)) != null) {
            String gitEnforcedPass = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption(GIT_ENFORCED_PASS, null);
            String gitEnforcedEmail = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption(GIT_ENFORCED_MAIL, null);
            return new UserPassEmailCredentialsProvider(gitEnforcedUser, gitEnforcedPass, gitEnforcedEmail);
        }
        String testsTokenIdentifier = "<oxy>";
        Object creds = GitCredentialsProvider.getSessionStore().get(contextId, GitCredentialsProvider.getCredentialKey(credentialType));
        switch (credentialType) {
            case USERPASS: {
                UsrPassEmail usrPassEmail = (UsrPassEmail)creds;
                if (usrPassEmail == null) break;
                return new UserPassEmailCredentialsProvider(usrPassEmail.userName, PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().decrypt(usrPassEmail.encryptedPassword), usrPassEmail.email);
            }
            case BITBUCKET: {
                BitbucketAccessToken bbToken = (BitbucketAccessToken)creds;
                if (bbToken == null) break;
                String accessToken = bbToken.getAccessToken();
                if (accessToken.contains("<oxy>")) {
                    String[] usrToken = accessToken.split("<oxy>");
                    return new UserPassEmailCredentialsProvider(usrToken[0], usrToken[1], null);
                }
                return new UserPassEmailCredentialsProvider(bbToken.getUsername(), bbToken.getAccessToken(), null);
            }
            case BITBUCKET_SERVER: {
                BitbucketServerAccessToken bbsvToken = (BitbucketServerAccessToken)creds;
                if (bbsvToken == null) break;
                String username = bbsvToken.getUserName();
                String accessToken = bbsvToken.getAccessToken();
                return new UserPassEmailCredentialsProvider(username, accessToken, null);
            }
            case GITLAB: 
            case GITLAB_E: {
                GitlabAccessToken glToken = (GitlabAccessToken)creds;
                if (glToken == null) break;
                String accessToken = glToken.getAccessToken();
                if (accessToken.startsWith("<oxy>")) {
                    accessToken = accessToken.substring(5);
                }
                return new UserPassEmailCredentialsProvider("oauth2", accessToken, null);
            }
            default: {
                String accessToken = (String)creds;
                if (accessToken == null) break;
                accessToken = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().decrypt(accessToken);
                return new UserPassEmailCredentialsProvider(accessToken, "", null);
            }
        }
        return null;
    }

    public static boolean sessionContainsCredentials(String sessionId, CredentialTypes credentialType) {
        return GitCredentialsProvider.getSessionStore().get(sessionId, GitCredentialsProvider.getCredentialKey(credentialType)) != null;
    }

    public static boolean userIsEnforced(String contextId, CredentialTypes credentialType) {
        String gitEnforcedUser;
        boolean userIsEnforced = false;
        if (credentialType == CredentialTypes.USERPASS && (gitEnforcedUser = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption(GIT_ENFORCED_USER, null)) != null) {
            userIsEnforced = true;
        }
        return userIsEnforced;
    }

    public static void setCredentials(String sessionId, CredentialTypes credentialType, Object creds) {
        if (creds != null) {
            if (creds instanceof String) {
                creds = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt((String)creds);
            }
            GitCredentialsProvider.getSessionStore().put(sessionId, GitCredentialsProvider.getCredentialKey(credentialType), creds);
        } else {
            GitCredentialsProvider.getSessionStore().remove(sessionId, GitCredentialsProvider.getCredentialKey(credentialType));
        }
    }

    public static void setUserPass(String sessionId, String username, String password, String email) {
        UsrPassEmail usrPassEmail = new UsrPassEmail();
        usrPassEmail.userName = username;
        usrPassEmail.encryptedPassword = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt(password);
        usrPassEmail.email = email;
        GitCredentialsProvider.getSessionStore().put(sessionId, GitCredentialsProvider.getCredentialKey(CredentialTypes.USERPASS), (Object)usrPassEmail);
    }

    public static void invalidateSession(String sessionId, CredentialTypes credentialType) {
        GitCredentialsProvider.getSessionStore().remove(sessionId, GitCredentialsProvider.getCredentialKey(credentialType));
    }

    public static void invalidateAll() {
        GitCredentialsProvider.getSessionStore().invalidateAll();
    }

    public static Integer getGitlabApiVersion() {
        return gitlabApiVersion;
    }

    public static void setGitlabApiVersion(Integer gitlabApiVersion) {
        GitCredentialsProvider.gitlabApiVersion = gitlabApiVersion;
    }

    public static Integer getGitlabEnterpriseApiVersion() {
        return gitlabEnterpriseApiVersion;
    }

    public static void setGitlabEnterpriseApiVersion(Integer gitlabEnterpriseApiVersion) {
        GitCredentialsProvider.gitlabEnterpriseApiVersion = gitlabEnterpriseApiVersion;
    }

    public static boolean isUsingEnforcedCredentials() {
        return PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption(GIT_ENFORCED_USER, null) != null;
    }

    static {
        gitlabRetrieveStrategy = null;
        gitlabEnterpriseRetrieveStrategy = null;
        bitbucketRetrieveStrategy = null;
        githubApiUrl = null;
        githubRetrieveStrategy = null;
        bitbucketServerRetrieveStrategy = null;
    }

    private static final class UsrPassEmail {
        public String userName;
        public String encryptedPassword;
        public String email;

        private UsrPassEmail() {
        }
    }
}

