/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.admin.IProtectionEntry;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.admin.ProtectionEntry;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.GetProtectionEntriesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IProtectsDelegator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ProtectsDelegator
extends BaseDelegator
implements IProtectsDelegator {
    public ProtectsDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IProtectionEntry> getProtectionEntries(boolean allUsers, String hostName, String userName, String groupName, List<IFileSpec> fileList) throws ConnectionException, RequestException, AccessException {
        try {
            GetProtectionEntriesOptions opts = new GetProtectionEntriesOptions().setAllUsers(allUsers).setHostName(hostName).setUserName(userName).setGroupName(groupName);
            return this.getProtectionEntries(fileList, opts);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IProtectionEntry> getProtectionEntries(List<IFileSpec> fileList, GetProtectionEntriesOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.PROTECTS, Parameters.processParameters((Options)opts, fileList, null, false, (IServer)this.server), null);
        AtomicInteger order = new AtomicInteger(-1);
        return ResultListBuilder.buildNonNullObjectListFromCommandResultMaps(resultMaps, map -> new ProtectionEntry((Map<String, Object>)map, order.incrementAndGet()));
    }
}

