/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.core.IServerProcess;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.ServerProcess;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.server.GetServerProcessesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IMonitorDelegator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MonitorDelegator
extends BaseDelegator
implements IMonitorDelegator {
    public MonitorDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IServerProcess> getServerProcesses() throws ConnectionException, RequestException, AccessException {
        try {
            return this.getServerProcesses(null);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IServerProcess> getServerProcesses(GetServerProcessesOptions opts) throws P4JavaException {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("show"));
        String[] options = Parameters.processParameters(opts, this.server);
        if (Objects.nonNull(options) && options.length > 0) {
            args.addAll(Arrays.asList(options));
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.MONITOR, args.toArray(new String[args.size()]), null);
        return ResultListBuilder.buildNonNullObjectListFromCommandResultMaps(resultMaps, map -> new ServerProcess((Map<String, Object>)map));
    }
}

