/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.core.ILabelSummary;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.LabelSummary;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.server.GetLabelsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.ILabelsDelegator;
import java.util.List;
import java.util.Map;

public class LabelsDelegator
extends BaseDelegator
implements ILabelsDelegator {
    public LabelsDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<ILabelSummary> getLabels(String user, int maxLabels, String nameFilter, List<IFileSpec> fileList) throws ConnectionException, RequestException, AccessException {
        this.checkMinSupportedPerforceVersion(user, maxLabels, nameFilter, "label");
        try {
            GetLabelsOptions getLabelsOptions = new GetLabelsOptions().setMaxResults(maxLabels).setUserName(user).setNameFilter(nameFilter);
            return this.getLabels(fileList, getLabelsOptions);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<ILabelSummary> getLabels(List<IFileSpec> fileList, GetLabelsOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LABELS, Parameters.processParameters(opts, fileList, this.server), null);
        return ResultListBuilder.buildNonNullObjectListFromCommandResultMaps(resultMaps, map -> new LabelSummary((Map<String, Object>)map));
    }
}

