/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.graph.IGraphListTree;
import com.perforce.p4java.impl.generic.graph.GraphListTree;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IGraphListTreeDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GraphListTreeDelegator
extends BaseDelegator
implements IGraphListTreeDelegator {
    public GraphListTreeDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IGraphListTree> getGraphListTree(String sha) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GRAPH, Parameters.processParameters(null, null, new String[]{"ls-tree", sha}, (IServer)this.server), null);
        if (!Objects.nonNull(resultMaps)) {
            return null;
        }
        int mode = -1;
        String type = null;
        String rsha = null;
        String name = null;
        ArrayList<IGraphListTree> graphListTreeList = new ArrayList<IGraphListTree>();
        Map<String, Object> map = resultMaps.get(0);
        int index = 0;
        while (Objects.nonNull(map.get("sha" + index))) {
            try {
                if (map.containsKey("mode" + index)) {
                    mode = P4ResultMapUtils.parseInt(map, "mode" + index);
                }
                if (map.containsKey("type" + index)) {
                    type = P4ResultMapUtils.parseString(map, "type" + index);
                }
                if (map.containsKey("sha" + index)) {
                    rsha = P4ResultMapUtils.parseString(map, "sha" + index);
                }
                if (map.containsKey("name" + index)) {
                    name = P4ResultMapUtils.parseString(map, "name" + index);
                }
            }
            catch (Throwable thr) {
                Log.exception(thr);
            }
            graphListTreeList.add(new GraphListTree(mode, type, rsha, name));
            ++index;
        }
        return graphListTreeList;
    }
}

