/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.ChangelistSummary;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.server.GetChangelistsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IChangesDelegator;
import java.util.List;
import java.util.Map;

public class ChangesDelegator
extends BaseDelegator
implements IChangesDelegator {
    public ChangesDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IChangelistSummary> getChangelists(int maxMostRecent, List<IFileSpec> fileSpecs, String clientName, String userName, boolean includeIntegrated, IChangelist.Type type, boolean longDesc) throws ConnectionException, RequestException, AccessException {
        try {
            GetChangelistsOptions getChangelistsOptions = new GetChangelistsOptions().setClientName(clientName).setIncludeIntegrated(includeIntegrated).setLongDesc(longDesc).setMaxMostRecent(maxMostRecent).setType(type).setUserName(userName);
            return this.getChangelists(fileSpecs, getChangelistsOptions);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IChangelistSummary> getChangelists(int maxMostRecent, List<IFileSpec> fileSpecs, String clientName, String userName, boolean includeIntegrated, boolean submittedOnly, boolean pendingOnly, boolean longDesc) throws ConnectionException, RequestException, AccessException {
        IChangelist.Type type = null;
        if (submittedOnly) {
            type = IChangelist.Type.SUBMITTED;
        } else if (pendingOnly) {
            type = IChangelist.Type.PENDING;
        }
        return this.getChangelists(maxMostRecent, fileSpecs, clientName, userName, includeIntegrated, type, longDesc);
    }

    @Override
    public List<IChangelistSummary> getChangelists(List<IFileSpec> fileSpecs, GetChangelistsOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CHANGES, Parameters.processParameters(opts, fileSpecs, this.server), null);
        return ResultListBuilder.buildNonNullObjectListFromCommandResultMaps(resultMaps, map -> new ChangelistSummary((Map<String, Object>)map, true));
    }
}

