/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.mapbased.rpc.ServerStats;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class RpcSocketInputStream
extends InputStream {
    public static final String TRACE_PREFIX = "RpcSocketInputStream";
    private Socket socket = null;
    private InputStream socketStream = null;
    private ServerStats stats = null;

    public RpcSocketInputStream(Socket socket, ServerStats stats) {
        if (socket == null) {
            throw new NullPointerError("null RPC socket passed to RpcSocketInputStream constructor");
        }
        this.socket = socket;
        this.stats = stats;
        try {
            this.socketStream = socket.getInputStream();
        }
        catch (IOException ioexc) {
            Log.error("Unexpected I/O exception thrown during input stream retrieval in RpcSocketInputStream constructor: " + ioexc.getLocalizedMessage(), new Object[0]);
            Log.exception(ioexc);
            throw new P4JavaError("Unexpected I/O exception thrown during input stream retrieval in RpcSocketInputStream constructor: " + ioexc.getLocalizedMessage());
        }
    }

    @Override
    public int read() throws IOException {
        if (this.socketStream == null) {
            throw new NullPointerError("null socket stream in RpcSocketInputStream.read()");
        }
        int retVal = this.socketStream.read();
        if (this.stats != null && this.stats.largestRecv.get() < (long)retVal) {
            this.stats.largestRecv.set(retVal);
        }
        return retVal;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        if (this.socketStream == null) {
            throw new NullPointerError("null socket stream in RpcSocketInputStream.read()");
        }
        if (bytes == null) {
            throw new NullPointerError("null byte array in RpcSocketInputStream.read()");
        }
        int retVal = this.socketStream.read(bytes);
        if (this.stats != null && this.stats.largestRecv.get() < (long)retVal) {
            this.stats.largestRecv.set(retVal);
        }
        return retVal;
    }

    @Override
    public int read(byte[] bytes, int offset, int len) throws IOException {
        if (this.socketStream == null) {
            throw new NullPointerError("null socket stream in RpcSocketInputStream.read()");
        }
        if (bytes == null) {
            throw new NullPointerError("null byte array in RpcSocketInputStream.read()");
        }
        int retVal = this.socketStream.read(bytes, offset, len);
        if (this.stats != null && this.stats.largestRecv.get() < (long)retVal) {
            this.stats.largestRecv.set(retVal);
        }
        return retVal;
    }

    protected Socket getSocket() {
        return this.socket;
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
    }

    protected InputStream getSockStream() {
        return this.socketStream;
    }

    protected void setSockStream(InputStream sockStream) {
        this.socketStream = sockStream;
    }
}

