/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.packet;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.ProtocolError;
import com.perforce.p4java.impl.mapbased.rpc.ExternalEnv;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionMapKey;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketField;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketPreamble;
import com.perforce.p4java.impl.mapbased.rpc.packet.helper.RpcPacketFieldRule;
import com.perforce.p4java.server.callback.IFilterCallback;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class RpcPacket {
    public static final int DEFAULT_RPC_PACKET_BUFFER_SIZE = 2048;
    public static final int RPC_LENGTH_FIELD_LENGTH = 4;
    public static final String TRACE_PREFIX = "RpcPacket";
    private RpcFunctionSpec funcName = null;
    private String funcNameString = null;
    private ExternalEnv env = null;
    private String[] strArgs = null;
    private Map<String, Object> mapArgs = null;
    private Map<String, Object> resultsMap = null;
    private int packetLength = 0;

    public static byte[] encodeInt4(int i) {
        byte[] bytes = new byte[]{(byte)(i / 1 % 256), (byte)(i / 256 % 256), (byte)(i / 65536 % 256), (byte)(i / 0x1000000 % 256)};
        return bytes;
    }

    public static int decodeInt4(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerError("Null bytes passed to RpcPacket.decodeInt");
        }
        if (bytes.length != 4) {
            throw new ProtocolError("Bad byte array size in RpcPacket.decodeInt: " + bytes.length);
        }
        return (bytes[0] & 0xFF) * 1 + (bytes[1] & 0xFF) * 256 + (bytes[2] & 0xFF) * 65536 + (bytes[3] & 0xFF) * 0x1000000;
    }

    public static RpcPacket constructRpcPacket(RpcFunctionSpec funcName, String realName, String[] args, ExternalEnv env) {
        return new RpcPacket(funcName, realName, args, env);
    }

    public static RpcPacket constructRpcPacket(RpcFunctionSpec funcName, Map<String, Object> args, ExternalEnv env) {
        return new RpcPacket(funcName, args, env);
    }

    public static RpcPacket constructRpcPacket(String funcName, Map<String, Object> args, ExternalEnv env) {
        return new RpcPacket(funcName, args, env);
    }

    public static RpcPacket constructRpcPacket(RpcPacketPreamble preamble, byte[] bytes, boolean isUnicodeServer, Charset charset) {
        return RpcPacket.constructRpcPacket(preamble, bytes, isUnicodeServer, charset, null, null);
    }

    public static RpcPacket constructRpcPacket(RpcPacketPreamble preamble, byte[] bytes, boolean isUnicodeServer, Charset charset, RpcPacketFieldRule fieldRule, IFilterCallback filterCallback) {
        return new RpcPacket(preamble, bytes, isUnicodeServer, charset, fieldRule, filterCallback);
    }

    private RpcPacket(RpcFunctionSpec funcName, String realName, String[] args, ExternalEnv env) {
        if (funcName == null) {
            throw new NullPointerError("Null function name passed to RpcPacket constructor");
        }
        this.funcName = funcName;
        this.funcNameString = funcName == RpcFunctionSpec.USER_SPECIFIED ? "user-" + realName : funcName.getEncoding();
        this.strArgs = args;
        this.env = env;
    }

    private RpcPacket(RpcFunctionSpec funcName, Map<String, Object> args, ExternalEnv env) {
        if (funcName == null) {
            throw new NullPointerError("Null function name passed to RpcPacket constructor");
        }
        this.funcName = funcName;
        this.funcNameString = funcName.getEncoding();
        this.mapArgs = args;
        this.env = env;
    }

    private RpcPacket(String funcName, Map<String, Object> args, ExternalEnv env) {
        if (funcName == null) {
            throw new NullPointerError("Null function name passed to RpcPacket constructor");
        }
        this.funcNameString = funcName;
        this.mapArgs = args;
        this.env = env;
    }

    private RpcPacket(Map<String, Object> resultsMap, int packetLength) {
        this.resultsMap = resultsMap;
        this.packetLength = packetLength;
        if (resultsMap != null) {
            this.funcNameString = (String)resultsMap.get("func");
        }
    }

    private RpcPacket(RpcPacketPreamble preamble, byte[] payloadBytes, boolean isUnicodeServer, Charset charset, RpcPacketFieldRule fieldRule, IFilterCallback filterCallback) {
        if (preamble == null) {
            throw new NullPointerError("null RPC preamble passed to RpcPacket constructor");
        }
        if (!preamble.isValidChecksum()) {
            throw new ProtocolError("Bad checksum in RPC preamble passed to RpcPacket constructor");
        }
        if (payloadBytes == null) {
            throw new NullPointerError("null payload byte array passed to RpcPacket constructor");
        }
        int payloadLength = preamble.getPayloadSize();
        if (payloadLength != payloadBytes.length) {
            throw new P4JavaError("bad byte array size in RpcPacket constructor; byte array length: " + payloadBytes.length + "; from preamble: " + payloadLength);
        }
        try {
            this.resultsMap = new HashMap<String, Object>();
            ByteBuffer packetBuf = ByteBuffer.wrap(payloadBytes);
            Map<String, String> doNotSkipKeysMap = filterCallback != null ? filterCallback.getDoNotSkipKeysMap() : null;
            AtomicBoolean skipSubsequent = new AtomicBoolean(false);
            while (packetBuf.position() < packetBuf.limit()) {
                Object[] fields = RpcPacketField.retrievePacketField(packetBuf, isUnicodeServer, charset, fieldRule);
                if (filterCallback != null && !RpcFunctionMapKey.RPC_KEYS_MAP.containsKey((String)fields[0]) && (doNotSkipKeysMap == null || !doNotSkipKeysMap.containsKey((String)fields[0])) && (skipSubsequent != null && skipSubsequent.get() || filterCallback.skip((String)fields[0], fields[1], skipSubsequent))) continue;
                if (fields[0] == null) {
                    this.resultsMap.put(null, fields[1]);
                    continue;
                }
                String fieldName = (String)fields[0];
                if (fieldName.equalsIgnoreCase("func2")) {
                    if (this.resultsMap.containsKey(fieldName)) continue;
                    this.resultsMap.put(fieldName, fields[1]);
                    continue;
                }
                if (this.resultsMap.containsKey(fieldName)) {
                    int suffixCounter = 0;
                    while (this.resultsMap.containsKey(fieldName + suffixCounter)) {
                        ++suffixCounter;
                    }
                    this.resultsMap.put(fieldName + suffixCounter, fields[1]);
                    continue;
                }
                this.resultsMap.put(fieldName, fields[1]);
            }
            this.packetLength = payloadLength;
            if (this.resultsMap != null) {
                this.funcNameString = (String)this.resultsMap.get("func");
            }
            if (filterCallback != null) {
                filterCallback.reset();
            }
        }
        catch (ProtocolError pe) {
            throw pe;
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: " + thr.getLocalizedMessage(), new Object[0]);
            Log.exception(thr);
            throw new ProtocolError(thr.getLocalizedMessage(), thr);
        }
    }

    public Map<String, Object> getResultsMap() {
        return this.resultsMap;
    }

    public void setResultsMap(Map<String, Object> resultsMap) {
        this.resultsMap = resultsMap;
    }

    public String getFuncNameString() {
        return this.funcNameString;
    }

    public void setFuncNameString(String funcNameString) {
        this.funcNameString = funcNameString;
    }

    public int getPacketLength() {
        return this.packetLength;
    }

    public void setPacketLength(int packetLength) {
        this.packetLength = packetLength;
    }

    public String[] getStrArgs() {
        return this.strArgs;
    }

    public void setStrArgs(String[] strArgs) {
        this.strArgs = strArgs;
    }

    public Map<String, Object> getMapArgs() {
        return this.mapArgs;
    }

    public void setMapArgs(Map<String, Object> mapArgs) {
        this.mapArgs = mapArgs;
    }

    public ExternalEnv getEnv() {
        return this.env;
    }

    public void setEnv(ExternalEnv env) {
        this.env = env;
    }
}

