/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientHelper;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcInputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceDigestType;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SymbolicLinkHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class ClientSendFile {
    public static final String TRACE_PREFIX = "ClientSendFile";
    private Properties props = null;
    private final ISystemFileCommandsHelper fileCommands = SysFileHelperBridge.getSysFileCommands();
    private String filePath = null;
    private long fileSize = 0L;
    private long currentSize = 0L;

    protected ClientSendFile(Properties props) {
        this.props = props;
    }

    private long sendStream(InputStream stream, RpcConnection connection, String handle, String write, MD5Digester digester, CommandEnv cmdEnv) throws ConnectionException, IOException {
        int bytesRead;
        long fileLength = 0L;
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        byte[] bytes = new byte[65536];
        while ((bytesRead = stream.read(bytes)) > 0) {
            byte[] readBytes = new byte[bytesRead];
            System.arraycopy(bytes, 0, readBytes, 0, bytesRead);
            fileLength += (long)bytesRead;
            sendMap.clear();
            sendMap.put("data", readBytes);
            sendMap.put("handle", handle);
            RpcPacket sendPacket = RpcPacket.constructRpcPacket(write, sendMap, null);
            connection.putRpcPacket(sendPacket);
            digester.update(readBytes);
            this.currentSize = ClientHelper.sendBackWrittenDataBytes(cmdEnv, this.filePath, this.fileSize, this.currentSize, bytesRead);
        }
        return fileLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RpcPacketDispatcher.RpcPacketDispatcherResult sendFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        Object localDigest;
        boolean chmodReopen;
        cmdEnv.newHandler();
        String clientPath = (String)resultsMap.get("path");
        String type = (String)resultsMap.get("type");
        String perms = (String)resultsMap.get("perms");
        String handle = (String)resultsMap.get("handle");
        String open = (String)resultsMap.get("open");
        String write = (String)resultsMap.get("write");
        String confirm = (String)resultsMap.get("confirm");
        String decline = (String)resultsMap.get("decline");
        String serverDigest = (String)resultsMap.get("serverDigest");
        String digestType = (String)resultsMap.get("digestType");
        String revertUnchanged = (String)resultsMap.get("revertUnchanged");
        String depotTime = (String)resultsMap.get("depotTime");
        String reopen = (String)resultsMap.get("reopen");
        String skipDigestCheck = (String)resultsMap.get("skipDigestCheck");
        String pendingDigest = (String)resultsMap.get("pendingDigest");
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(handle);
        if (handler == null) {
            CommandEnv commandEnv = cmdEnv;
            commandEnv.getClass();
            handler = commandEnv.new CommandEnv.RpcHandler(handle, false, null);
            cmdEnv.addHandler(handler);
        }
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        InputStream inStream = null;
        MD5Digester digester = null;
        String sProto = cmdEnv.getServerProtocolSpecsMap().containsKey("server2") ? (String)cmdEnv.getServerProtocolSpecsMap().get("server2") : (String)cmdEnv.getServerProtocolSpecsMap().get("server");
        int serverProtocol = 0;
        try {
            serverProtocol = Integer.parseInt(sProto);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        boolean bl = chmodReopen = serverProtocol >= 42;
        if (skipDigestCheck != null) {
            resultsMap.put("status", "same");
            resultsMap.put("sha", skipDigestCheck);
            rpcConnection.clientConfirm(confirm, resultsMap);
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        RpcPerforceFile file = new RpcPerforceFile(clientPath, type);
        boolean sendDigest = serverProtocol >= 17;
        boolean sendFileSize = serverProtocol >= 19;
        long fileLength = 0L;
        long modTime = file.lastModified();
        if (file.getFileType() == RpcPerforceFileType.FST_SYMLINK && (modTime = SymbolicLinkHelper.getLastModifiedTime(clientPath)) == 0L) {
            modTime = System.currentTimeMillis();
        }
        if (modTime != 0L) {
            modTime /= 1000L;
        }
        if (digestType != null && (localDigest = rpcConnection.getDigest(file.getFileType(), file, RpcPerforceDigestType.GetType(digestType))) != null && ((String)localDigest).equals(serverDigest)) {
            resultsMap.put("status", "same");
            resultsMap.put("sha", localDigest);
            rpcConnection.clientConfirm(confirm, resultsMap);
            if (perms == null) return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            if (revertUnchanged == null) return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (modTime != 0L && !sendDigest) {
            resultsMap.put("time", "" + modTime);
        }
        try {
            try {
                this.filePath = clientPath != null && !clientPath.isEmpty() ? clientPath : null;
                this.fileSize = file.length();
                this.currentSize = 0L;
                if (!handler.isError()) {
                    for (Map.Entry entry : resultsMap.entrySet()) {
                        String string = (String)entry.getKey();
                        if (string == null || "func".equalsIgnoreCase(string)) continue;
                        respMap.put((String)entry.getKey(), entry.getValue());
                    }
                    RpcPacket respPacket = RpcPacket.constructRpcPacket(open, respMap, null);
                    rpcConnection.putRpcPacket(respPacket);
                    if (!file.exists() && file.getFileType() != RpcPerforceFileType.FST_SYMLINK) {
                        handler.setError(true);
                        cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.OS_FILE_READ_ERROR, 1, 34, new String[]{"open for read", clientPath + ": No such file or directory"}).toMap());
                    } else {
                        void var35_47;
                        void var34_38;
                        Object var34_35 = null;
                        if (file.getFileType() == RpcPerforceFileType.FST_SYMLINK) {
                            String string;
                            if (SymbolicLinkHelper.isSymbolicLinkCapable() && (string = SymbolicLinkHelper.readSymbolicLink(clientPath)) != null) {
                                String string2 = string + "\n";
                            }
                            if (var34_38 == null) {
                                handler.setError(true);
                                cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_SEND_ERROR, 3, 34, new String[]{"symlink", clientPath}).toMap());
                                RpcPacketDispatcher.RpcPacketDispatcherResult rpcPacketDispatcherResult = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                                return rpcPacketDispatcherResult;
                            }
                        }
                        digester = new MD5Digester();
                        Object var35_43 = null;
                        if (RpcPerforceFileType.FST_UTF16 == file.getFileType() || RpcPerforceFileType.FST_XUTF16 == file.getFileType()) {
                            Charset charset = CharsetDefs.UTF16;
                        } else if (RpcPerforceFileType.FST_UTF8 == file.getFileType() || RpcPerforceFileType.FST_XUTF8 == file.getFileType()) {
                            Charset charset = CharsetDefs.UTF8;
                        } else if (RpcPerforceFileType.FST_UNICODE == file.getFileType() || RpcPerforceFileType.FST_XUNICODE == file.getFileType()) {
                            Charset charset = rpcConnection.getClientCharset();
                        }
                        inStream = !rpcConnection.isUnicodeServer() && var35_47 != CharsetDefs.UTF16 || var35_47 == null || var35_47.equals(CharsetDefs.UTF8) ? (var34_38 == null ? new RpcInputStream(file, null) : new ByteArrayInputStream(var34_38.getBytes())) : (var34_38 == null ? new RpcInputStream(file, (Charset)var35_47) : new ByteArrayInputStream(var34_38.getBytes()));
                        fileLength = this.sendStream(inStream, rpcConnection, handle, write, digester, cmdEnv);
                        if (!handler.isError() && Objects.nonNull(perms) && Objects.isNull(reopen)) {
                            boolean symlink = file.getFileType() == RpcPerforceFileType.FST_SYMLINK;
                            boolean writable = perms.equalsIgnoreCase("rw");
                            this.fileCommands.setWritable(clientPath, writable || symlink);
                        }
                    }
                }
                String finalise = handler.isError() ? decline : confirm;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                for (Map.Entry<String, Object> entry : resultsMap.entrySet()) {
                    String key = entry.getKey();
                    if (!Objects.nonNull(key) || "func".equalsIgnoreCase(key)) continue;
                    hashMap.put(entry.getKey(), entry.getValue());
                }
                if (digester != null) {
                    hashMap.put("digest", digester.digestAs32ByteHex());
                    hashMap.put("fileSize", String.valueOf(fileLength));
                    if (modTime != 0L) {
                        hashMap.put("time", String.valueOf(modTime));
                    }
                }
                RpcPacket rpcPacket = RpcPacket.constructRpcPacket(finalise, hashMap, null);
                rpcConnection.putRpcPacket(rpcPacket);
                handler.setError(false);
                this.filePath = null;
                this.fileSize = 0L;
                this.currentSize = 0L;
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            finally {
                if (Objects.nonNull(inStream)) {
                    inStream.close();
                }
            }
        }
        catch (Exception exc) {
            Log.exception(exc);
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_SEND_ERROR, 3, 34, new String[]{clientPath, exc.getLocalizedMessage()}).toMap());
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }
}

