/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core.file;

import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IRevisionIntegrationData;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class FileRevisionData
implements IFileRevisionData {
    private int revision = 0;
    private int changeListId = -1;
    private FileAction action = null;
    private Date date = null;
    private String userName = null;
    private String fileType = null;
    private String description = null;
    private String depotFileName = null;
    private String clientName = null;
    private List<IRevisionIntegrationData> revisionIntegrationDataList = null;

    public FileRevisionData() {
    }

    public FileRevisionData(Map<String, Object> map, int revNo) {
        if (Objects.nonNull(map)) {
            String revStr = "";
            if (revNo >= 0) {
                revStr = revStr + revNo;
            }
            this.setRevision(P4ResultMapUtils.parseInt(map, "rev" + revNo));
            String changeId = P4ResultMapUtils.parseString(map, "change" + revStr);
            if (StringUtils.isNotBlank((CharSequence)changeId)) {
                if ("default".equalsIgnoreCase(changeId)) {
                    this.setChangelistId(0);
                } else {
                    this.setChangelistId(Integer.parseInt(changeId));
                }
            }
            this.setAction(FileAction.fromString(P4ResultMapUtils.parseString(map, "action" + revStr)));
            this.setDate(new Date(P4ResultMapUtils.parseLong(map, "time" + revStr) * 1000L));
            this.setUserName(P4ResultMapUtils.parseString(map, "user" + revStr));
            this.setFileType(P4ResultMapUtils.parseString(map, "type" + revStr));
            this.setDescription(P4ResultMapUtils.parseString(map, "desc" + revStr));
            this.setDepotFileName(P4ResultMapUtils.parseString(map, "depotFile"));
            this.setClientName(P4ResultMapUtils.parseString(map, "client" + revStr));
            int revRev = 0;
            String fromFile = P4ResultMapUtils.parseString(map, "file" + revNo + "," + revRev);
            while (StringUtils.isNotBlank((CharSequence)fromFile)) {
                if (Objects.isNull(this.revisionIntegrationDataList)) {
                    this.revisionIntegrationDataList = new ArrayList<IRevisionIntegrationData>();
                }
                RevisionIntegrationData revisionIntegrationData = new RevisionIntegrationData(P4ResultMapUtils.parseString(map, "srev" + revNo + "," + revRev), P4ResultMapUtils.parseString(map, "erev" + revNo + "," + revRev), fromFile, P4ResultMapUtils.parseString(map, "how" + revNo + "," + revRev));
                this.revisionIntegrationDataList.add(revisionIntegrationData);
                fromFile = P4ResultMapUtils.parseString(map, "file" + revNo + "," + ++revRev);
            }
        }
    }

    public void setChangelistId(int changeListId) {
        this.changeListId = changeListId;
    }

    public FileRevisionData(int revision, int changeListId, FileAction action, Date date, String userName, String fileType, String description, String depotFileName, String clientName) {
        this.revision = revision;
        this.changeListId = changeListId;
        this.action = action;
        this.date = date;
        this.userName = userName;
        this.fileType = fileType;
        this.description = description;
        this.depotFileName = depotFileName;
        this.clientName = clientName;
    }

    @Override
    public FileAction getAction() {
        return this.action;
    }

    public void setAction(FileAction action) {
        this.action = action;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public String getDepotFileName() {
        return this.depotFileName;
    }

    public void setDepotFileName(String depotFileName) {
        this.depotFileName = depotFileName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public List<IRevisionIntegrationData> getRevisionIntegrationDataList() {
        return this.revisionIntegrationDataList;
    }

    @Override
    @Deprecated
    public List<IRevisionIntegrationData> getRevisionIntegrationData() {
        return this.getRevisionIntegrationDataList();
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public int getChangelistId() {
        return this.changeListId;
    }

    private class RevisionIntegrationData
    implements IRevisionIntegrationData {
        private int startFromRev = 0;
        private int endFromRev = 0;
        private String fromFile = null;
        private String howFrom = null;

        RevisionIntegrationData(String startFromRev, String endFromRev, String fromFile, String howFrom) {
            this.startFromRev = FileSpec.getRevFromString(startFromRev);
            this.endFromRev = FileSpec.getRevFromString(endFromRev);
            this.fromFile = fromFile;
            this.howFrom = howFrom;
        }

        @Override
        public int getEndFromRev() {
            return this.endFromRev;
        }

        @Override
        public String getFromFile() {
            return this.fromFile;
        }

        @Override
        public String getHowFrom() {
            return this.howFrom;
        }

        @Override
        public int getStartFromRev() {
            return this.startFromRev;
        }
    }
}

