/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IUserSummary;
import com.perforce.p4java.impl.generic.core.ServerResource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class UserSummary
extends ServerResource
implements IUserSummary {
    private String loginName = null;
    private String email = null;
    private String fullName = null;
    private Date access = null;
    private Date update = null;
    protected IUserSummary.UserType type = null;
    protected Date ticketExpiration = null;
    protected Date passwordChange = null;
    static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";

    public UserSummary() {
    }

    public UserSummary(String loginName, String email, String fullName, Date access, Date update) {
        this.loginName = loginName;
        this.email = email;
        this.fullName = fullName;
        this.access = access;
        this.update = update;
    }

    public UserSummary(String loginName, String email, String fullName, Date access, Date update, IUserSummary.UserType type) {
        this.loginName = loginName;
        this.email = email;
        this.fullName = fullName;
        this.access = access;
        this.update = update;
        this.type = type;
    }

    public UserSummary(Map<String, Object> map, boolean summaryOnly) {
        super(!summaryOnly, !summaryOnly);
        if (map != null) {
            try {
                this.loginName = (String)map.get("User");
                this.email = (String)map.get("Email");
                this.fullName = (String)map.get("FullName");
                if (map.containsKey("Type")) {
                    this.type = IUserSummary.UserType.fromString(((String)map.get("Type")).toUpperCase());
                }
                if (summaryOnly) {
                    this.update = new Date(Long.parseLong((String)map.get("Update")) * 1000L);
                    this.access = new Date(Long.parseLong((String)map.get("Access")) * 1000L);
                    if (map.get("TicketExpiration") != null) {
                        this.ticketExpiration = new Date(Long.parseLong((String)map.get("TicketExpiration")) * 1000L);
                    }
                    if (map.get("PasswordChange") != null) {
                        this.passwordChange = new Date(Long.parseLong((String)map.get("PasswordChange")) * 1000L);
                    }
                } else {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
                    if (map.containsKey("Update")) {
                        this.update = simpleDateFormat.parse((String)map.get("Update"));
                    }
                    if (map.containsKey("Access")) {
                        this.access = simpleDateFormat.parse((String)map.get("Access"));
                    }
                    if (map.get("passwordChange") != null) {
                        this.passwordChange = simpleDateFormat.parse((String)map.get("passwordChange"));
                    }
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in UserSummary constructor: " + thr.getLocalizedMessage(), new Object[0]);
                Log.exception(thr);
            }
        }
    }

    @Override
    public Date getAccess() {
        return this.access;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getLoginName() {
        return this.loginName;
    }

    @Override
    public Date getUpdate() {
        return this.update;
    }

    @Override
    public void setAccess(Date access) {
        this.access = access;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    @Override
    public void setUpdate(Date update) {
        this.update = update;
    }

    @Override
    public IUserSummary.UserType getType() {
        return this.type;
    }

    @Override
    public void setType(IUserSummary.UserType type) {
        this.type = type;
    }

    @Override
    public Date getTicketExpiration() {
        return this.ticketExpiration;
    }

    @Override
    public Date getPasswordChange() {
        return this.passwordChange;
    }
}

