/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.core.file;

import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class FileSpecBuilder {
    private FileSpecBuilder() {
    }

    public static List<IFileSpec> makeFileSpecList(@Nullable List<String> filePaths) {
        ArrayList<IFileSpec> fileSpecs = new ArrayList<IFileSpec>();
        if (Objects.nonNull(filePaths)) {
            for (String filePath : filePaths) {
                if (!StringUtils.isNotBlank((CharSequence)filePath)) continue;
                FileSpec fileSpec = new FileSpec(filePath);
                fileSpecs.add(fileSpec);
            }
        }
        return fileSpecs;
    }

    public static List<IFileSpec> makeFileSpecList(String ... filePaths) {
        ArrayList<IFileSpec> fileSpecs = new ArrayList<IFileSpec>();
        if (filePaths != null) {
            for (String path : filePaths) {
                if (!StringUtils.isNotBlank((CharSequence)path)) continue;
                fileSpecs.add(new FileSpec(path));
            }
        }
        return fileSpecs;
    }

    public static List<IFileSpec> makeFileSpecListSpecialChars(String ... filePaths) {
        ArrayList<IFileSpec> fileSpecs = new ArrayList<IFileSpec>();
        if (filePaths != null) {
            for (String path : filePaths) {
                if (!StringUtils.isNotBlank((CharSequence)path)) continue;
                path = path.replaceAll("%", "%25");
                path = path.replaceAll("@", "%40");
                path = path.replaceAll("#", "%23");
                path = path.replaceAll("\\*", "%2A");
                fileSpecs.add(new FileSpec(path));
            }
        }
        return fileSpecs;
    }

    public static List<IFileSpec> getValidFileSpecs(@Nullable List<IFileSpec> fileSpecs) {
        ArrayList<IFileSpec> validFileSpecs = new ArrayList<IFileSpec>();
        if (Objects.nonNull(fileSpecs)) {
            for (IFileSpec fileSpec : fileSpecs) {
                if (!Objects.nonNull(fileSpec) || fileSpec.getOpStatus() != FileSpecOpStatus.VALID) continue;
                validFileSpecs.add(fileSpec);
            }
        }
        return validFileSpecs;
    }

    public static List<IFileSpec> getInvalidFileSpecs(@Nullable List<IFileSpec> fileSpecs) {
        ArrayList<IFileSpec> invalidFileSpecs = new ArrayList<IFileSpec>();
        if (Objects.nonNull(fileSpecs)) {
            for (IFileSpec fileSpec : fileSpecs) {
                if (!Objects.nonNull(fileSpec) || fileSpec.getOpStatus() == FileSpecOpStatus.VALID || fileSpec.getOpStatus() == FileSpecOpStatus.INFO) continue;
                invalidFileSpecs.add(fileSpec);
            }
        }
        return invalidFileSpecs;
    }
}

