/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown;

import com.elovirta.dita.markdown.DitaRenderer;
import com.elovirta.dita.markdown.MDitaReader;
import com.elovirta.dita.markdown.MarkdownParser;
import com.elovirta.dita.markdown.MarkdownParserImpl;
import com.elovirta.dita.markdown.ParseException;
import com.elovirta.dita.markdown.SchemaProvider;
import com.elovirta.dita.markdown.math.SimpleLatexMathExtension;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.CharStreams;
import com.oxygenxml.md.ExternalOptionProvider;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.admonition.AdmonitionExtension;
import com.vladsch.flexmark.ext.anchorlink.AnchorLinkExtension;
import com.vladsch.flexmark.ext.attributes.AttributesExtension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.definition.DefinitionExtension;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughSubscriptExtension;
import com.vladsch.flexmark.ext.ins.InsExtension;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagExtension;
import com.vladsch.flexmark.ext.superscript.SuperscriptExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.io.BufferedInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;

public class MarkdownReader
implements XMLReader {
    private static final Pattern schemaPattern = Pattern.compile("^---[\r\n]+\\$schema: +(.+?)[\r\n]");
    private static final ServiceLoader<SchemaProvider> schemaLoader = ServiceLoader.load(SchemaProvider.class);
    public static final DataKey<Collection<String>> FORMATS = new DataKey("FORMATS", List.of("markdown", "md"));
    public static final DataKey<Boolean> PROCESSING_MODE = new DataKey("PROCESSING_MODE", (Object)false);
    private static final Map<String, DataKey<Boolean>> FEATURES;
    private final MutableDataSet options;
    EntityResolver resolver;
    ContentHandler contentHandler;
    ErrorHandler errorHandler;
    private boolean embedBackmappingData;
    private String mdSystemID;

    public MarkdownReader() {
        this(new ExternalOptionProvider(){

            @Override
            public boolean shouldCorrectHeadingLevels() {
                return true;
            }
        });
    }

    public MarkdownReader(ExternalOptionProvider provider) {
        this((DataSet)new MutableDataSet().set(Parser.EXTENSIONS, Arrays.asList(SimpleLatexMathExtension.create(), AbbreviationExtension.create(), AdmonitionExtension.create(), AnchorLinkExtension.create(), AttributesExtension.create(), FootnoteExtension.create(), InsExtension.create(), JekyllTagExtension.create(), SuperscriptExtension.create(), TablesExtension.create(), AutolinkExtension.create(), YamlFrontMatterExtension.create(), DefinitionExtension.create(), StrikethroughSubscriptExtension.create())).set(DefinitionExtension.TILDE_MARKER, (Object)false).set(TablesExtension.COLUMN_SPANS, (Object)true).set(TablesExtension.APPEND_MISSING_COLUMNS, (Object)false).set(TablesExtension.DISCARD_EXTRA_COLUMNS, (Object)true).set(TablesExtension.HEADER_SEPARATOR_COLUMN_MATCH, (Object)true).set(DitaRenderer.SPECIALIZATION, (Object)true).set(DitaRenderer.WIKI, (Object)false).set(DitaRenderer.CORRECT_HEADING_LEVELS, (Object)provider.shouldCorrectHeadingLevels()));
    }

    public MarkdownReader(DataSet options) {
        this.options = new MutableDataSet((DataHolder)options);
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        switch (name) {
            case "http://xml.org/sax/features/namespaces": {
                return true;
            }
            case "http://xml.org/sax/features/namespace-prefixes": {
                return false;
            }
        }
        DataKey<Boolean> option = FEATURES.get(name);
        if (option != null) {
            return (Boolean)option.get((DataHolder)this.options);
        }
        throw new SAXNotRecognizedException("Unrecognized feature " + name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        switch (name) {
            case "http://xml.org/sax/features/namespaces": {
                if (value) break;
                throw new SAXNotSupportedException("Unsupported value " + value + " for " + name);
            }
            case "http://xml.org/sax/features/namespace-prefixes": {
                if (!value) break;
                throw new SAXNotSupportedException("Unsupported value " + value + " for " + name);
            }
            case "http://lwdita.org/sax/features/mdita-extended-profile": {
                this.options.setAll((DataHolder)MDitaReader.EXTENDED_PROFILE);
                break;
            }
            case "http://lwdita.org/sax/features/mdita-core-profile": {
                this.options.setAll((DataHolder)MDitaReader.CORE_PROFILE);
                break;
            }
            case "http://xml.org/sax/features/external-general-entities": 
            case "http://xml.org/sax/features/external-parameter-entities": 
            case "http://xml.org/sax/features/is-standalone": 
            case "http://xml.org/sax/features/lexical-handler/parameter-entities": 
            case "http://xml.org/sax/features/resolve-dtd-uris": 
            case "http://xml.org/sax/features/string-interning": 
            case "http://xml.org/sax/features/unicode-normalization-checking": 
            case "http://xml.org/sax/features/use-attributes2": 
            case "http://xml.org/sax/features/use-locator2": 
            case "http://xml.org/sax/features/use-entity-resolver2": 
            case "http://xml.org/sax/features/validation": 
            case "http://xml.org/sax/features/xmlns-uris": 
            case "http://xml.org/sax/features/xml-1.1": {
                break;
            }
            default: {
                DataKey<Boolean> option = FEATURES.get(name);
                if (option != null) {
                    this.options.set(option, (Object)value);
                    break;
                }
                throw new SAXNotRecognizedException("Unrecognized feature " + name);
            }
        }
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException {
        switch (name) {
            case "https://dita-ot.org/property/formats": {
                this.options.set(FORMATS, (Object)((Collection)value));
                break;
            }
            case "https://dita-ot.org/property/processing-mode": {
                this.options.set(PROCESSING_MODE, (Object)"strict".equals(value));
                break;
            }
            case "http://xml.org/sax/properties/declaration-handler": 
            case "http://xml.org/sax/properties/document-xml-version": 
            case "http://xml.org/sax/properties/dom-node": 
            case "http://xml.org/sax/properties/lexical-handler": 
            case "http://xml.org/sax/properties/xml-string": {
                break;
            }
            default: {
                throw new SAXNotRecognizedException(String.format("Property %s not supported", name));
            }
        }
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        char[] markdownContent = this.getMarkdownContent(input);
        Map.Entry<URI, Locator> schema = this.getSchema(markdownContent, input);
        BasedSequence sequence = BasedSequence.of((CharSequence)CharBuffer.wrap(markdownContent));
        MarkdownParser markdownParser = this.getParser(schema);
        if (this.embedBackmappingData) {
            markdownParser.enableBackmappingData(this.mdSystemID);
        }
        markdownParser.setContentHandler(this.contentHandler);
        markdownParser.setErrorHandler(this.errorHandler);
        try {
            markdownParser.convert(sequence, Optional.ofNullable(input.getSystemId()).map(URI::create).orElse(null));
        }
        catch (ParseException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw new SAXException(e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    private MarkdownParser getParser(Map.Entry<URI, Locator> schema) throws SAXException {
        if (schema != null) {
            URI value = schema.getKey();
            Optional<MarkdownParser> markdownParser = schemaLoader.stream().filter(p -> ((SchemaProvider)p.get()).isSupportedSchema(value)).findAny().map(s -> ((SchemaProvider)s.get()).createMarkdownParser(value));
            if (markdownParser.isEmpty() && this.errorHandler != null) {
                this.errorHandler.error(new SAXParseException(String.format("Markdown schema %s not recognized, using default Markdown parser", value), schema.getValue()));
            }
            return markdownParser.orElse(new MarkdownParserImpl(this.options.toImmutable()));
        }
        return new MarkdownParserImpl(this.options.toImmutable());
    }

    @VisibleForTesting
    Map.Entry<URI, Locator> getSchema(char[] data, InputSource input) throws SAXParseException {
        Matcher matcher = schemaPattern.matcher(CharBuffer.wrap(data));
        if (matcher.find() && matcher.group(1) != null) {
            String value = matcher.group(1).replaceAll("^'(.+)'$", "$1").replaceAll("^\"(.+)\"$", "$1").trim();
            LocatorImpl locator = new LocatorImpl();
            locator.setSystemId(input.getSystemId());
            locator.setPublicId(input.getPublicId());
            int row = 1;
            int col = 1;
            int end = matcher.end(1);
            for (int i = 0; i < data.length; ++i) {
                if (i == end) {
                    locator.setLineNumber(row);
                    locator.setColumnNumber(col);
                    break;
                }
                if (data[i] == '\n') {
                    ++row;
                    col = 1;
                    continue;
                }
                if (data[i] == '\r') continue;
                ++col;
            }
            try {
                URI schema = new URI(value);
                return Map.entry(schema, locator);
            }
            catch (URISyntaxException e) {
                throw new SAXParseException(String.format("Failed to parse schema URI %s ", value), locator, e);
            }
        }
        return null;
    }

    @VisibleForTesting
    char[] getMarkdownContent(InputSource input) throws IOException {
        CharArrayWriter out;
        block33: {
            out = new CharArrayWriter();
            if (input.getByteStream() != null) {
                String encoding = input.getEncoding() != null ? input.getEncoding() : "UTF-8";
                try (BufferedInputStream is = "UTF-8".equalsIgnoreCase(encoding) ? this.consumeBOM(input.getByteStream()) : new BufferedInputStream(input.getByteStream());
                     InputStreamReader in = new InputStreamReader((InputStream)is, encoding);){
                    CharStreams.copy((Readable)in, (Appendable)out);
                    break block33;
                }
            }
            if (input.getCharacterStream() != null) {
                try (Reader in = input.getCharacterStream();){
                    CharStreams.copy((Readable)in, (Appendable)out);
                }
            }
            if (input.getSystemId() != null) {
                URL inUrl;
                try {
                    inUrl = new URI(input.getSystemId()).toURL();
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                String encoding = input.getEncoding() != null ? input.getEncoding() : "UTF-8";
                try (BufferedInputStream is = "UTF-8".equalsIgnoreCase(encoding) ? this.consumeBOM(inUrl.openStream()) : new BufferedInputStream(inUrl.openStream());
                     InputStreamReader in = new InputStreamReader((InputStream)is, encoding);){
                    CharStreams.copy((Readable)in, (Appendable)out);
                }
            }
        }
        return out.toCharArray();
    }

    private BufferedInputStream consumeBOM(InputStream in) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(in);
        bin.mark(3);
        try {
            if (bin.read() != 239 || bin.read() != 187 || bin.read() != 191) {
                bin.reset();
            }
        }
        catch (IOException e) {
            bin.reset();
        }
        return bin;
    }

    public void enableBackmappingData(String mdSystemID) {
        this.embedBackmappingData = true;
        this.mdSystemID = mdSystemID;
    }

    static {
        HashMap<String, DataKey<Boolean>> features = new HashMap<String, DataKey<Boolean>>();
        features.put("http://lwdita.org/sax/features/shortdesc-paragraph", DitaRenderer.SHORTDESC_PARAGRAPH);
        features.put("http://lwdita.org/sax/features/tight-list", DitaRenderer.TIGHT_LIST);
        features.put("http://lwdita.org/sax/features/id-from-yaml", DitaRenderer.ID_FROM_YAML);
        features.put("http://lwdita.org/sax/features/mdita", DitaRenderer.MDITA_EXTENDED_PROFILE);
        features.put("http://lwdita.org/sax/features/mdita-extended-profile", DitaRenderer.MDITA_EXTENDED_PROFILE);
        features.put("http://lwdita.org/sax/features/mdita-core-profile", DitaRenderer.MDITA_CORE_PROFILE);
        features.put("http://lwdita.org/sax/features/specialization", DitaRenderer.SPECIALIZATION);
        features.put("http://lwdita.org/sax/features/specialization-concept", DitaRenderer.SPECIALIZATION_CONCEPT);
        features.put("http://lwdita.org/sax/features/specialization-task", DitaRenderer.SPECIALIZATION_TASK);
        features.put("http://lwdita.org/sax/features/specialization-reference", DitaRenderer.SPECIALIZATION_REFERENCE);
        features.put("http://lwdita.org/sax/features/fix-root-heading", DitaRenderer.FIX_ROOT_HEADING);
        features.put("http://lwdita.org/sax/features/map", DitaRenderer.MAP);
        FEATURES = Collections.unmodifiableMap(features);
    }
}

