/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown;

import com.elovirta.dita.markdown.CleanerFilter;
import com.elovirta.dita.markdown.DitaRenderer;
import com.elovirta.dita.markdown.MarkdownParser;
import com.elovirta.dita.markdown.MarkdownReader;
import com.elovirta.dita.markdown.ParseException;
import com.elovirta.dita.markdown.SpecializeFilter;
import com.elovirta.dita.markdown.renderer.HeaderIdGenerator;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ext.anchorlink.AnchorLink;
import com.vladsch.flexmark.ext.yaml.front.matter.AbstractYamlFrontMatterVisitor;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterBlock;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MarkdownParserImpl
implements MarkdownParser {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("com.elovirta.dita.messages");
    private final DataSet options;
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private boolean embedBackmappingData;
    private String mdSystemID;

    public MarkdownParserImpl(DataSet options) {
        this.options = options;
    }

    @Override
    public void convert(BasedSequence sequence, URI input) throws SAXException {
        Parser parser = Parser.builder((DataHolder)this.options).build();
        Document root = parser.parse(sequence);
        try {
            Document cleaned = this.preprocess(root, input);
            this.validate(cleaned);
            this.render(cleaned);
        }
        catch (ParseException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void render(Document root) {
        SpecializeFilter specialize;
        ContentHandler res = this.contentHandler;
        CleanerFilter cleanerFilter = new CleanerFilter();
        cleanerFilter.setContentHandler(res);
        res = cleanerFilter;
        if (((Boolean)DitaRenderer.SPECIALIZATION.get((DataHolder)this.options)).booleanValue()) {
            specialize = new SpecializeFilter();
            specialize.setContentHandler(res);
            res = specialize;
        } else if (((Boolean)DitaRenderer.SPECIALIZATION_CONCEPT.get((DataHolder)this.options)).booleanValue()) {
            specialize = new SpecializeFilter(SpecializeFilter.Type.CONCEPT);
            specialize.setContentHandler(res);
            res = specialize;
        } else if (((Boolean)DitaRenderer.SPECIALIZATION_TASK.get((DataHolder)this.options)).booleanValue()) {
            specialize = new SpecializeFilter(SpecializeFilter.Type.TASK);
            specialize.setContentHandler(res);
            res = specialize;
        } else if (((Boolean)DitaRenderer.SPECIALIZATION_REFERENCE.get((DataHolder)this.options)).booleanValue()) {
            specialize = new SpecializeFilter(SpecializeFilter.Type.REFERENCE);
            specialize.setContentHandler(res);
            res = specialize;
        }
        DitaRenderer s = new DitaRenderer(this.options);
        if (this.embedBackmappingData) {
            s.renderWithBackMaping((Node)root, res, this.mdSystemID);
        } else {
            s.render((Node)root, res);
        }
    }

    protected void validate(Document root) {
        boolean mditaCoreProfile = (Boolean)DitaRenderer.MDITA_CORE_PROFILE.get((DataHolder)this.options);
        boolean mditaExtendedProfile = (Boolean)DitaRenderer.MDITA_EXTENDED_PROFILE.get((DataHolder)this.options) != false || (Boolean)DitaRenderer.LW_DITA.get((DataHolder)this.options) != false;
        boolean shouldCorrectHeadingLevels = (Boolean)DitaRenderer.CORRECT_HEADING_LEVELS.get((DataHolder)this.options);
        int level = 0;
        for (Node node = root.getFirstChild(); node != null; node = node.getNext()) {
            if (!(node instanceof Heading)) continue;
            Heading heading = (Heading)node;
            if ((mditaCoreProfile || mditaExtendedProfile) && heading.getLevel() > 2) {
                throw new ParseException(String.format(MESSAGES.getString("error.lwdita_invalid_level"), heading.getLevel(), heading.getText()));
            }
            if ((!shouldCorrectHeadingLevels || mditaCoreProfile || mditaExtendedProfile) && heading.getLevel() > level + 1) {
                throw new ParseException(String.format(MESSAGES.getString("error.heading_skip"), level, heading.getLevel()));
            }
            level = heading.getLevel();
        }
    }

    protected Document preprocess(Document root, URI input) throws SAXException {
        boolean shouldCorrectHeadingLevels = (Boolean)DitaRenderer.CORRECT_HEADING_LEVELS.get((DataHolder)this.options);
        if (!shouldCorrectHeadingLevels && MarkdownParserImpl.isWiki(root) && !((Boolean)DitaRenderer.MAP.get((DataHolder)this.options)).booleanValue()) {
            Map<String, String> header = this.parseYamlHeader(root);
            if (((Boolean)DitaRenderer.WIKI.get((DataHolder)this.options)).booleanValue()) {
                this.generateRootHeading(root, header.get("id"), header.getOrDefault("title", this.getTextFromFile(input)));
            } else if (((Boolean)DitaRenderer.FIX_ROOT_HEADING.get((DataHolder)this.options)).booleanValue()) {
                if (this.errorHandler != null) {
                    this.errorHandler.warning(new SAXParseException(MESSAGES.getString("error.missing_title"), null, input.toString(), 1, 1));
                }
                this.generateRootHeading(root, header.get("id"), header.getOrDefault("title", this.getTextFromFile(input)));
            } else if (((Boolean)MarkdownReader.PROCESSING_MODE.get((DataHolder)this.options)).booleanValue()) {
                if (this.errorHandler != null) {
                    this.errorHandler.error(new SAXParseException(MESSAGES.getString("error.missing_title"), null, input.toString(), 1, 1));
                }
            } else {
                String id;
                if (this.errorHandler != null) {
                    this.errorHandler.warning(new SAXParseException(MESSAGES.getString("error.missing_title"), null, input != null ? input.toString() : "", 1, 1));
                }
                if ((id = header.get("id")) == null && input != null) {
                    id = HeaderIdGenerator.generateId((CharSequence)this.getTextFromFile(input), (String)((String)DitaRenderer.HEADER_ID_GENERATOR_TO_DASH_CHARS.get((DataHolder)root)), (boolean)((Boolean)DitaRenderer.HEADER_ID_GENERATOR_NO_DUPED_DASHES.get((DataHolder)root)));
                }
                this.generateRootHeading(root, id, header.get("title"));
            }
        }
        return root;
    }

    private static String getId(String contents) {
        return contents.toLowerCase().replaceAll("[^\\w\\s]", "").trim().replaceAll("\\s+", "-");
    }

    private Map<String, String> parseYamlHeader(Document root) {
        YamlFrontMatterBlock yaml;
        HashMap<String, String> res = new HashMap<String, String>();
        YamlFrontMatterBlock yamlFrontMatterBlock = yaml = root.getFirstChild() instanceof YamlFrontMatterBlock ? (YamlFrontMatterBlock)root.getFirstChild() : null;
        if (yaml != null) {
            List titles;
            AbstractYamlFrontMatterVisitor v = new AbstractYamlFrontMatterVisitor();
            v.visit((Node)root);
            Map metadata = v.getData();
            List ids = (List)metadata.get("id");
            if (ids != null && !ids.isEmpty()) {
                res.put("id", (String)ids.get(0));
            }
            if ((titles = (List)metadata.get("title")) != null && !titles.isEmpty()) {
                String title = (String)titles.get(0);
                if (title.charAt(0) == '\'' && title.charAt(title.length() - 1) == '\'' || title.charAt(0) == '\"' && title.charAt(title.length() - 1) == '\"') {
                    title = title.substring(1, title.length() - 1);
                }
                res.put("title", title);
            }
        }
        return res;
    }

    private void generateRootHeading(Document root, String id, String title) {
        Heading heading = new Heading();
        if (id != null) {
            heading.setAnchorRefId(id);
        }
        heading.setLevel(1);
        if (id == null) {
            AnchorLink anchorLink = new AnchorLink();
            anchorLink.appendChild((Node)new Text(title != null ? title : ""));
            heading.appendChild((Node)anchorLink);
        } else {
            heading.appendChild((Node)new Text(title != null ? title : ""));
        }
        root.prependChild((Node)heading);
    }

    private static boolean isWiki(Document root) {
        Node firstChild = root.getFirstChild();
        if (firstChild == null) {
            return false;
        }
        if (firstChild instanceof YamlFrontMatterBlock) {
            firstChild = firstChild.getNext();
        }
        return !(firstChild instanceof Heading) || ((Heading)firstChild).getLevel() != 1;
    }

    private String getTextFromFile(URI file) {
        String path = file.getPath();
        String name = path.substring(path.lastIndexOf("/") + 1);
        String title = name.lastIndexOf(".") != -1 ? name.substring(0, name.lastIndexOf(".")) : name;
        return title.replace('_', ' ').replace('-', ' ');
    }

    @Override
    public void enableBackmappingData(String mdSystemID) {
        this.embedBackmappingData = true;
        this.mdSystemID = mdSystemID;
    }
}

