/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.outline;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.InvalidEditException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

@WebappRestSafe
@WebappCompatible
public class OutlineMoveNodeOperation
extends AuthorOperationWithResult {
    private static final Logger log = LoggerFactory.getLogger(OutlineMoveNodeOperation.class);

    public String doOperation(AuthorDocumentModel authorDocumentModel, ArgumentsMap args) throws AuthorOperationException {
        long sourceNodeId = Long.parseLong((String)args.getArgumentValue("sourceNodeId"));
        long targetNodeId = Long.parseLong((String)args.getArgumentValue("targetNodeId"));
        String position = (String)args.getArgumentValue("position");
        try {
            int dropOffset;
            AuthorNode sourceNode = (AuthorNode)authorDocumentModel.getNodeIndexer().getObjectById(sourceNodeId);
            AuthorNode targetNode = (AuthorNode)authorDocumentModel.getNodeIndexer().getObjectById(targetNodeId);
            if (targetNode != null && targetNode != null) {
                dropOffset = targetNode.getStartOffset();
                if (position.equals("Inside, at the beginning")) {
                    ++dropOffset;
                } else if (position.equals("After")) {
                    dropOffset = targetNode.getEndOffset() + 1;
                }
            } else {
                PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
                String errorMessage = rb.getMessage("MOVE_FAILED_BECAUSE_DOC_CHANGED_WHILE_DRAGGING");
                AuthorOperationException authorOperationException = new AuthorOperationException(errorMessage);
                authorOperationException.setOperationRejectedOnPurpose(true);
                throw authorOperationException;
            }
            authorDocumentModel.getActionsSupport().handleDragAndDrop(sourceNode.getStartOffset(), sourceNode.getEndOffset(), dropOffset);
        }
        catch (BadLocationException e) {
            log.error("Could not determine node location ", (Throwable)e);
        }
        catch (InvalidEditException e) {
            log.error("Invalid edit ", (Throwable)e);
        }
        return null;
    }
}

