/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.outline;

import com.oxygenxml.outline.OutlineConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.ClassPathResourcesAccess;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;

public class OutlineConfigurationProvider {
    private static final Logger log = LoggerFactory.getLogger(OutlineConfigurationProvider.class);
    private AuthorDocumentModel documentModel;
    private static final String OUTLINE_CONFIG_FILE_NAME = "webAuthorOutlineConfig.xml";

    public OutlineConfigurationProvider(AuthorDocumentModel documentModel) {
        this.documentModel = documentModel;
    }

    public OutlineConfiguration getConfiguration() {
        OutlineConfiguration configuration;
        block3: {
            configuration = null;
            URL configurationFile = this.getConfigurationFile();
            if (configurationFile != null) {
                try {
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{OutlineConfiguration.class});
                    Unmarshaller unmarshaller = jc.createUnmarshaller();
                    configuration = (OutlineConfiguration)unmarshaller.unmarshal(configurationFile);
                }
                catch (JAXBException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Could not retrieve the outline configuration properties", (Throwable)e);
                }
            }
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getConfigurationFile() {
        URL[] resources;
        URL resourceURL = null;
        ClassPathResourcesAccess classPathResourcesAccess = this.documentModel.getAuthorAccess().getClassPathResourcesAccess();
        if (classPathResourcesAccess != null && (resources = classPathResourcesAccess.getClassPathResources()) != null) {
            for (int i = 0; i < resources.length; ++i) {
                URL url = resources[i];
                InputStream is = null;
                try {
                    URL possibleResourceUrl = new URL(url, OUTLINE_CONFIG_FILE_NAME);
                    is = possibleResourceUrl.openStream();
                    is.read();
                    resourceURL = possibleResourceUrl;
                    break;
                }
                catch (IOException iOException) {
                    continue;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return resourceURL;
    }
}

