/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.p4operations.P4Client;
import com.oxygenxml.perforce.p4operations.P4DepotPath;
import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.option.server.GetFileContentsOptions;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShelfOperation {
    private static final Logger log = LoggerFactory.getLogger(ShelfOperation.class);
    private Integer changelistId;

    public ShelfOperation(Integer changelistId) {
        this.changelistId = changelistId;
    }

    public Void deleteFiles(P4Client p4Client, P4DepotPath p4DepotPath) throws P4OperationException {
        List<IFileSpec> fileSpecs = p4DepotPath.createExFileSpecs();
        List<IFileSpec> shelveSpecs = p4Client.shelve(fileSpecs, this.changelistId, "-d");
        for (IFileSpec fs : shelveSpecs) {
            if (!Objects.nonNull(fs) || fs.getOpStatus() != FileSpecOpStatus.ERROR) continue;
            log.warn("ERROR deleting shelved file:{} - {}", (Object)p4DepotPath, (Object)fs);
        }
        return null;
    }

    public InputStream readFiles(P4Client p4Client, P4DepotPath p4DepotPath) throws P4OperationException {
        log.debug("Getting shelved content from changelist: {}", (Object)this.changelistId);
        List<IFileSpec> checkSpecList = p4DepotPath.createExFileSpecs("@=" + this.changelistId);
        GetFileContentsOptions gfco = new GetFileContentsOptions();
        gfco.setNoHeaderLine(true);
        gfco.setDontAnnotateFiles(false);
        return p4Client.getFileContents(checkSpecList, gfco);
    }

    public static Optional<Integer> getChangelistId(P4Client p4Client, P4DepotPath p4DepotPath) throws P4OperationException {
        List<IFileSpec> fileSpecs = p4DepotPath.createExFileSpecs();
        Optional<IChangelist> optChangelist = p4Client.getLastPendingChangelist(fileSpecs);
        return optChangelist.map(IChangelistSummary::getId).filter(id -> {
            List<IFileSpec> checkSpecList = p4DepotPath.createExFileSpecs("@=" + id);
            List<IFileSpec> fs = p4Client.getDepotFiles(checkSpecList, new String[0]);
            boolean hasShelvedFiles = fs.stream().noneMatch(f -> f.getOpStatus() == FileSpecOpStatus.ERROR);
            if (hasShelvedFiles) {
                log.debug("Found shelved files: {} in changelist: {}", fs, id);
            }
            return hasShelvedFiles;
        });
    }
}

