/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.oxygenxml.perforce.p4operations.P4PermissionException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveFromFileSystemTemplate {
    private static final Logger log = LoggerFactory.getLogger(SaveFromFileSystemTemplate.class);
    private P4SaveOperation saveOperation;

    public SaveFromFileSystemTemplate(P4SaveOperation saveOperation) {
        this.saveOperation = saveOperation;
    }

    public void save(byte[] content, String depotPath) throws P4OperationException, P4PermissionException {
        Path parentTmpDir;
        block8: {
            parentTmpDir = null;
            Path tmpDir = null;
            try {
                parentTmpDir = Files.createTempDirectory("web-author-perforce-plugin", new FileAttribute[0]);
                tmpDir = Files.createTempDirectory(parentTmpDir, "tmp", new FileAttribute[0]);
                File file = Paths.get(tmpDir.toString(), depotPath).toFile();
                if (!file.getCanonicalPath().startsWith(tmpDir.toFile().getCanonicalPath())) {
                    throw new IOException("Invalid depot path");
                }
                FileUtils.writeByteArrayToFile((File)file, (byte[])content);
                log.info("Submiting file:{} with path:{}. Client root:{}", new Object[]{file.getAbsolutePath(), depotPath, tmpDir});
                this.saveOperation.save(tmpDir);
                if (tmpDir == null) break block8;
            }
            catch (IOException e) {
                try {
                    log.error("P4 write operation to path {} failed", (Object)depotPath, (Object)e);
                    throw new P4OperationException("Write operation to:" + depotPath + "failed.", e);
                }
                catch (Throwable throwable) {
                    if (tmpDir != null) {
                        SaveFromFileSystemTemplate.deleteTemporaryFiles(tmpDir);
                    }
                    if (parentTmpDir != null) {
                        this.deleteEmptyDirectory(parentTmpDir);
                    }
                    throw throwable;
                }
            }
            SaveFromFileSystemTemplate.deleteTemporaryFiles(tmpDir);
        }
        if (parentTmpDir != null) {
            this.deleteEmptyDirectory(parentTmpDir);
        }
    }

    private void deleteEmptyDirectory(Path dir) throws P4OperationException {
        try {
            Files.delete(dir);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new P4OperationException(e.getMessage(), e);
        }
    }

    static void deleteTemporaryFiles(Path path) throws P4OperationException {
        try {
            PathUtils.deleteDirectory((Path)path, (DeleteOption[])new DeleteOption[]{StandardDeleteOption.OVERRIDE_READ_ONLY});
            log.debug("Temporary dir:{} deleted", (Object)path);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new P4OperationException(e.getMessage(), e);
        }
    }

    static interface P4SaveOperation {
        public void save(Path var1) throws P4OperationException, P4PermissionException;
    }
}

