/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.Configuration;
import com.oxygenxml.perforce.p4operations.P4Client;
import com.oxygenxml.perforce.p4operations.P4DepotPath;
import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.oxygenxml.perforce.p4operations.P4PermissionException;
import com.oxygenxml.perforce.p4operations.P4Server;
import com.oxygenxml.perforce.p4operations.P4Utils;
import com.oxygenxml.perforce.p4operations.SaveFromFileSystemTemplate;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.OpenedFilesOptions;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P4WriteOperation {
    private static final Logger log = LoggerFactory.getLogger(P4WriteOperation.class);
    private P4Server server;
    private String depotPath;
    private P4DepotPath p4depot;
    private String message;

    public P4WriteOperation(URI uri, PasswordAuthentication credentials, String message, Configuration configuration) throws P4OperationException {
        this.p4depot = P4DepotPath.of(uri);
        this.depotPath = this.p4depot.getPath();
        if (this.depotPath.indexOf(42) != -1 || this.depotPath.indexOf("%%") != -1 || this.depotPath.indexOf("...") != -1) {
            throw new P4OperationException("The path " + this.depotPath + " contains invalid characters. (*, %% and ... are not allowed)");
        }
        this.server = new P4Server(uri, credentials, configuration);
        this.message = message;
    }

    public void write(byte[] content) throws P4OperationException, P4PermissionException {
        SaveFromFileSystemTemplate storage = new SaveFromFileSystemTemplate(this::submit);
        storage.save(content, this.depotPath);
    }

    void submit(Path rootFolder) throws P4OperationException, P4PermissionException {
        try {
            this.server.connect();
            P4Client p4Client = new P4Client(this.server, rootFolder.toString(), this.depotPath);
            IChangelist changelist = p4Client.createNewChangelist(this.message);
            EditStrategy editStrategy = this.getEditStrategy(p4Client, changelist.getId());
            List<IFileSpec> editSpecs = editStrategy.editFiles();
            P4Utils.validateFileSpecs(editSpecs);
            changelist.update();
            changelist.refresh();
            List submitSpecs = changelist.submit(false);
            P4Utils.validateFileSpecs(submitSpecs);
        }
        catch (P4JavaException e) {
            throw new P4OperationException(e.getMessage(), e);
        }
        finally {
            this.server.disconnect();
        }
    }

    private EditStrategy getEditStrategy(P4Client p4Client, int changeListId) throws P4JavaException {
        if (this.server.fileExists(this.p4depot)) {
            log.debug("EDIT existing file:{}", (Object)this.p4depot);
            return () -> this.editOrReopen(p4Client, changeListId);
        }
        log.debug("ADD new file:{}", (Object)this.p4depot);
        return () -> this.addFiles(p4Client, changeListId);
    }

    private List<IFileSpec> addFiles(P4Client p4Client, int changeListId) throws P4JavaException {
        List<IFileSpec> fileList = this.p4depot.createFileSpecs();
        return p4Client.unwrap().addFiles(fileList, false, changeListId, null, true);
    }

    private List<IFileSpec> editOrReopen(P4Client p4Client, int changeListId) throws P4JavaException {
        List<IFileSpec> fileList = this.p4depot.createExFileSpecs();
        IClient client = p4Client.unwrap();
        client.sync(fileList, false, false, true, false);
        OpenedFilesOptions ofo = new OpenedFilesOptions(new String[]{"-C", client.getName()});
        List openedSpecs = client.openedFiles(fileList, ofo);
        List resSpecs = openedSpecs.isEmpty() ? client.editFiles(fileList, false, false, changeListId, null) : client.reopenFiles(fileList, changeListId, null);
        return resSpecs;
    }

    private static interface EditStrategy {
        public List<IFileSpec> editFiles() throws P4JavaException;
    }
}

