/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P4Utils {
    private static final Logger log = LoggerFactory.getLogger(P4Utils.class);

    public static void validateFileSpecs(List<IFileSpec> specs) throws P4OperationException {
        for (IFileSpec fs : specs) {
            if (!Objects.nonNull(fs)) continue;
            FileSpecOpStatus ops = fs.getOpStatus();
            if (ops == FileSpecOpStatus.VALID) {
                log.info("Action {} - {} succeeded", (Object)fs.getAction(), (Object)fs);
                continue;
            }
            if (ops == FileSpecOpStatus.INFO) {
                log.info("{}", (Object)fs);
                continue;
            }
            log.error("{} -{}", (Object)ops, (Object)fs);
            throw new P4OperationException(fs.getStatusMessage());
        }
    }

    public static String expandWildcards(String path) {
        return path.replaceAll("%", "%25").replaceAll("@", "%40").replaceAll("#", "%23").replaceAll("\\*", "%25");
    }
}

