/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.Configuration;
import com.oxygenxml.perforce.p4operations.P4Client;
import com.oxygenxml.perforce.p4operations.P4DepotPath;
import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.oxygenxml.perforce.p4operations.P4PermissionException;
import com.oxygenxml.perforce.p4operations.P4Server;
import com.oxygenxml.perforce.p4operations.P4Utils;
import com.oxygenxml.perforce.p4operations.SaveFromFileSystemTemplate;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.client.ShelveFilesOptions;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P4ShelveOperation {
    private static final Logger log = LoggerFactory.getLogger(P4ShelveOperation.class);
    private P4Server server;
    private P4DepotPath p4DepotPath;
    private String depotPath;

    public P4ShelveOperation(URI uri, PasswordAuthentication credentials, Configuration configuration) throws P4OperationException {
        this.p4DepotPath = P4DepotPath.of(uri);
        this.depotPath = this.p4DepotPath.getPath();
        this.server = new P4Server(uri, credentials, configuration);
    }

    public void execute(byte[] content) throws P4OperationException, P4PermissionException {
        SaveFromFileSystemTemplate storage = new SaveFromFileSystemTemplate(this::execute);
        storage.save(content, this.depotPath);
    }

    void execute(Path rootFolder) throws P4PermissionException, P4OperationException {
        try {
            this.server.connect();
            P4Client p4Client = new P4Client(this.server, rootFolder.toString(), this.depotPath);
            List<IFileSpec> fileSpecs = this.p4DepotPath.createExFileSpecs();
            Optional<IChangelist> optChangelist = p4Client.getLastPendingChangelist(fileSpecs);
            IChangelist changelist = optChangelist.orElseThrow(() -> new P4OperationException("No changelist found for path:" + this.depotPath + " client:" + p4Client.getClientName()));
            int chListId = changelist.getId();
            IClient client = p4Client.unwrap();
            List shelveSpecs = client.shelveFiles(fileSpecs, chListId, new ShelveFilesOptions(new String[]{"-f"}));
            P4Utils.validateFileSpecs(shelveSpecs);
            log.debug("File {} shelved in: {}", (Object)this.depotPath, (Object)chListId);
        }
        catch (P4JavaException e) {
            log.error("Could not shelve files {}", (Object)this.depotPath, (Object)e);
            throw new P4OperationException("Could not shelve file " + this.depotPath, e);
        }
        finally {
            this.server.disconnect();
        }
    }
}

