/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.Configuration;
import com.oxygenxml.perforce.TrustedHostsProvider;
import com.oxygenxml.perforce.p4operations.P4DepotPath;
import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.oxygenxml.perforce.p4operations.P4PermissionException;
import com.oxygenxml.perforce.p4operations.P4ProgressCallback;
import com.oxygenxml.perforce.p4operations.UntrustedHostException;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.option.UsageOptions;
import com.perforce.p4java.option.server.TrustOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServerAddress;
import com.perforce.p4java.server.ServerFactory;
import com.perforce.p4java.server.callback.IProgressCallback;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.plugin.workspace.security.Response;

public class P4Server
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(P4Server.class);
    private URI serverUri;
    private IOptionsServer optionsServer;
    private PasswordAuthentication credentials;
    private Configuration configuration;

    public P4Server(URI uri, PasswordAuthentication credentials, Configuration configuration) throws P4OperationException {
        this.configuration = configuration;
        TrustedHostsProvider trustedHostProvider = new TrustedHostsProvider();
        String authority = uri.getHost() + ":" + uri.getPort();
        Response trustedStatus = trustedHostProvider.isTrusted(authority);
        if (TrustedHostsProvider.TRUSTED.getResponseType() != trustedStatus.getResponseType()) {
            throw new UntrustedHostException("Connection to \"" + authority + "\" was denied. Only connections to the server configured for the Perforce Connector are allowed.");
        }
        try {
            String scheme = this.computeScheme();
            this.credentials = credentials;
            this.serverUri = new URI(scheme + "://" + uri.getHost() + ":" + uri.getPort());
            this.optionsServer = this.getOptionsServer(null, null);
            this.optionsServer.registerProgressCallback((IProgressCallback)new P4ProgressCallback());
        }
        catch (P4JavaException | URISyntaxException e) {
            throw new P4OperationException(e.getMessage(), e);
        }
    }

    private String computeScheme() {
        String scheme = "p4java";
        if (this.configuration.isP4Ssl()) {
            scheme = "p4javassl";
        }
        return scheme;
    }

    private IOptionsServer getOptionsServer(Properties props, UsageOptions opts) throws P4JavaException, URISyntaxException {
        IOptionsServer server = ServerFactory.getOptionsServer((String)this.serverUri.toString(), (Properties)props, (UsageOptions)opts);
        if (IServerAddress.Protocol.P4JAVASSL.toString().equals(this.serverUri.getScheme())) {
            server.addTrust(new TrustOptions(true, false, true));
        }
        return server;
    }

    public void connect() throws P4PermissionException, P4OperationException {
        this.optionsServer.setUserName(this.credentials.getUserName());
        try {
            this.optionsServer.connect();
            this.optionsServer.login(new String(this.credentials.getPassword()));
        }
        catch (AccessException | RequestException e) {
            throw new P4PermissionException(e.getMessage(), e);
        }
        catch (ConfigException | ConnectionException e) {
            log.error("Could not connect to server {}", (Object)this.serverUri, (Object)e);
            throw new P4OperationException(e.getMessage(), e);
        }
    }

    public boolean fileExists(P4DepotPath p4DepotPath) throws AccessException, ConnectionException {
        List<IFileSpec> fileSpecs = p4DepotPath.createExFileSpecs();
        List depotFiles = this.optionsServer.getDepotFiles(fileSpecs, false);
        return !depotFiles.isEmpty() && depotFiles.get(0) != null && ((IFileSpec)depotFiles.get(0)).getAction() != null && ((IFileSpec)depotFiles.get(0)).getAction() != FileAction.DELETE;
    }

    public void disconnect() {
        try {
            this.optionsServer.disconnect();
        }
        catch (AccessException | ConnectionException e) {
            log.error("Could not disconnect from server {}", (Object)this.serverUri, (Object)e);
        }
    }

    public IOptionsServer unwrap() {
        return this.optionsServer;
    }

    public URI getServerURI() {
        return this.serverUri;
    }

    @Override
    public void close() throws Exception {
        try {
            this.optionsServer.disconnect();
        }
        catch (AccessException | ConnectionException e) {
            throw new P4OperationException();
        }
    }

    public P4Server(URI serverUri, IOptionsServer optionsServer, PasswordAuthentication credentials, Configuration configuration) {
        this.serverUri = serverUri;
        this.optionsServer = optionsServer;
        this.credentials = credentials;
        this.configuration = configuration;
    }
}

