/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.p4operations.P4Client;
import com.oxygenxml.perforce.p4operations.P4DepotPath;
import com.oxygenxml.perforce.p4operations.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.IFileSpec;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.plugin.lock.LockException;

public class P4RevertOperation {
    private static final Logger log = LoggerFactory.getLogger(P4RevertOperation.class);

    public static Void execute(P4Client p4Client, P4DepotPath p4DepotPath) throws LockException {
        try {
            List<IFileSpec> fileList = p4DepotPath.createExFileSpecs();
            IClient client = p4Client.unwrap();
            List revertedFiles = client.revertFiles(fileList, null);
            P4Utils.validateFileSpecs(revertedFiles);
            log.info("File {} - {} reverted ", (Object)p4Client.getClientName(), (Object)p4DepotPath);
            return null;
        }
        catch (Exception e) {
            log.error("Could not unlock revert:{}", (Object)p4DepotPath, (Object)e);
            throw new LockException(e.getMessage(), false, "Could not unlock resource: " + p4DepotPath + " for clientName: " + p4Client.getClientName());
        }
    }
}

