/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.Configuration;
import com.oxygenxml.perforce.p4operations.P4DepotPath;
import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.oxygenxml.perforce.p4operations.P4Server;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P4ReadOperation {
    private static final Logger log = LoggerFactory.getLogger(P4ReadOperation.class);
    private P4Server server;
    private P4DepotPath p4depot;

    public P4ReadOperation(URI uri, PasswordAuthentication credentials, Configuration configuration) throws P4OperationException {
        this.p4depot = P4DepotPath.of(uri);
        this.server = new P4Server(uri, credentials, configuration);
    }

    public InputStream read() throws Exception {
        log.info("Working with server URI {}", (Object)this.server.getServerURI());
        try {
            this.server.connect();
            List<IFileSpec> fileSpecList = this.p4depot.createExFileSpecs();
            List fileSpecs = this.server.unwrap().getDepotFiles(fileSpecList, false);
            List invalidSpecs = FileSpecBuilder.getInvalidFileSpecs((List)fileSpecs);
            if (!invalidSpecs.isEmpty()) {
                log.error("{}", (Object)invalidSpecs);
                throw new FileNotFoundException("Cannot read file at depot path: " + this.p4depot);
            }
            InputStream is = null;
            for (IFileSpec fileSpec : fileSpecs) {
                if (fileSpec == null || fileSpec.getOpStatus() != FileSpecOpStatus.VALID) continue;
                is = fileSpec.getContents(true);
                log.debug("Retrieved contents for: {}", (Object)fileSpec.getDepotPathString());
            }
            Iterator iterator = is;
            return iterator;
        }
        catch (RequestException rexc) {
            log.error(rexc.getDisplayString(), (Throwable)rexc);
            throw new P4OperationException(rexc.getDisplayString(), rexc);
        }
        catch (P4JavaException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new P4OperationException(e.getLocalizedMessage(), e);
        }
        finally {
            this.server.close();
        }
    }
}

