/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.Configuration;
import com.oxygenxml.perforce.p4operations.P4Client;
import com.oxygenxml.perforce.p4operations.P4DepotPath;
import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.oxygenxml.perforce.p4operations.P4Server;
import java.net.PasswordAuthentication;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.plugin.lock.LockException;

public class P4OperationTemplate<T> {
    private static final Logger log = LoggerFactory.getLogger(P4OperationTemplate.class);
    private P4Server server;
    private P4DepotPath p4DepotPath;
    private Configuration configuration;

    public P4OperationTemplate(URI uri, PasswordAuthentication credentials, Configuration configuration) throws P4OperationException {
        this.configuration = configuration;
        this.p4DepotPath = P4DepotPath.of(uri);
        this.server = new P4Server(uri, credentials, configuration);
    }

    public T call(Operation<T> operation) throws P4OperationException, LockException {
        try {
            this.server.connect();
            P4Client p4Client = new P4Client(this.server, this.p4DepotPath.getPath(), this.configuration);
            T t = operation.execute(p4Client, this.p4DepotPath);
            return t;
        }
        catch (LockException e) {
            log.error("Operation error:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Operation error:", (Throwable)e);
            throw new P4OperationException("Operation error: " + e.getMessage(), e);
        }
        finally {
            this.server.disconnect();
        }
    }

    public static <E> P4OperationTemplate<E> create(URI uri, PasswordAuthentication credentials, Configuration configuration) throws P4OperationException {
        return new P4OperationTemplate(uri, credentials, configuration);
    }

    public static interface Operation<T> {
        public T execute(P4Client var1, P4DepotPath var2) throws Exception;
    }
}

