/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.p4operations.P4Client;
import com.oxygenxml.perforce.p4operations.P4DepotPath;
import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.plugin.lock.LockException;

public class P4LockOperation {
    private static final Logger log = LoggerFactory.getLogger(P4LockOperation.class);

    public Void execute(P4Client p4Client, P4DepotPath p4DepotPath) throws P4OperationException, P4JavaException, LockException {
        List<IFileSpec> fileList = p4DepotPath.createExFileSpecs();
        IClient client = p4Client.unwrap();
        List<IFileSpec> lfSpecs = this.getLockingStrategy(client, fileList).lockFiles(fileList);
        log.debug("locked FileSpecs:{}", lfSpecs);
        if (!lfSpecs.isEmpty()) {
            FileSpecOpStatus lockOpStatus = lfSpecs.get(0).getOpStatus();
            log.debug("LockedFiles result {} - {}", (Object)lfSpecs.get(0).getOpStatus(), (Object)lockOpStatus);
            if (lockOpStatus != FileSpecOpStatus.VALID) {
                List revertedFiles = client.revertFiles(fileList, null);
                if (((IFileSpec)revertedFiles.get(0)).getOpStatus() != FileSpecOpStatus.VALID) {
                    log.warn("The file {} could not be reverted", (Object)revertedFiles);
                }
                throw new LockException(lfSpecs.get(0).getStatusMessage(), true, "Could not lock resource " + p4DepotPath);
            }
        }
        return null;
    }

    private LockingStrategy getLockingStrategy(IClient client, List<IFileSpec> fileSpecList) throws P4JavaException {
        List extfl = client.getServer().getExtendedFiles(fileSpecList, null);
        if (!extfl.isEmpty()) {
            IExtendedFileSpec fs = (IExtendedFileSpec)extfl.get(0);
            if (fs.isOtherLocked()) {
                log.debug("file {} is locked by other", fileSpecList);
                return fileList -> client.lockFiles(fileList, null);
            }
            if (!fs.isLocked()) {
                log.debug("file {} is locked", fileSpecList);
                return fileSpecs -> client.lockFiles(fileSpecs, null);
            }
        }
        return fileSpecs -> new ArrayList();
    }

    private static interface LockingStrategy {
        public List<IFileSpec> lockFiles(List<IFileSpec> var1) throws P4JavaException;
    }
}

