/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.Configuration;
import com.oxygenxml.perforce.p4operations.P4DepotPath;
import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.oxygenxml.perforce.p4operations.P4PermissionException;
import com.oxygenxml.perforce.p4operations.P4Server;
import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.option.server.GetDepotFilesOptions;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.net.protocol.FolderEntryDescriptor;

public class P4FileListOperation {
    private static final Logger log = LoggerFactory.getLogger(P4FileListOperation.class);
    private P4Server server;
    private P4DepotPath p4DepotPath;

    public P4FileListOperation(URI uri, PasswordAuthentication credentials, Configuration configuration) throws P4OperationException {
        this.p4DepotPath = P4DepotPath.of(uri);
        this.server = new P4Server(uri, credentials, configuration);
    }

    public List<FolderEntryDescriptor> getFolderEntryDescriptorList() throws P4PermissionException, P4OperationException {
        log.debug("Getting depot files for path {}", (Object)this.p4DepotPath);
        try {
            FolderEntryDescriptor folderEntryDescriptor;
            this.server.connect();
            ArrayList<FolderEntryDescriptor> folderEntryDescriptorList = new ArrayList<FolderEntryDescriptor>();
            if (this.p4DepotPath.isRoot()) {
                List depotList = this.server.unwrap().getDepots();
                for (IDepot depot : depotList) {
                    if (depot == null) continue;
                    FolderEntryDescriptor folderEntryDescriptor2 = new FolderEntryDescriptor(depot.getName());
                    folderEntryDescriptorList.add(folderEntryDescriptor2);
                }
                ArrayList<FolderEntryDescriptor> arrayList = folderEntryDescriptorList;
                return arrayList;
            }
            List<IFileSpec> fileSpecs = this.p4DepotPath.createExFileSpecs("*");
            List fileList = this.server.unwrap().getDepotFiles(fileSpecs, new GetDepotFilesOptions(new String[]{"-e"}));
            List folderList = this.server.unwrap().getDirectories(fileSpecs, false, false, false);
            for (IFileSpec fileSpec : fileList) {
                if (fileSpec == null) continue;
                if (fileSpec.getOpStatus() == FileSpecOpStatus.VALID) {
                    folderEntryDescriptor = new FolderEntryDescriptor(P4FileListOperation.formatFileSpec(fileSpec));
                    folderEntryDescriptorList.add(folderEntryDescriptor);
                    continue;
                }
                log.error(fileSpec.getStatusMessage());
            }
            for (IFileSpec folderSpec : folderList) {
                if (folderSpec == null) continue;
                if (folderSpec.getOpStatus() == FileSpecOpStatus.VALID) {
                    folderEntryDescriptor = new FolderEntryDescriptor(folderSpec.toString() + "/");
                    folderEntryDescriptorList.add(folderEntryDescriptor);
                    continue;
                }
                log.error(folderSpec.getStatusMessage());
            }
            ArrayList<FolderEntryDescriptor> arrayList = folderEntryDescriptorList;
            return arrayList;
        }
        catch (RequestException e) {
            log.error(e.getDisplayString(), (Throwable)e);
            throw new P4OperationException(e);
        }
        catch (P4JavaException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new P4OperationException(e);
        }
        finally {
            this.server.disconnect();
        }
    }

    private static String formatFileSpec(IFileSpec fileSpec) {
        return fileSpec.getDepotPathString();
    }
}

