/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.p4operations.P4Utils;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.IFileSpec;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P4DepotPath {
    private static final Logger log = LoggerFactory.getLogger(P4DepotPath.class);
    private String depotPath;
    private static final String URL_MATCHER_REGEX = "^/([0-9_]*)/";
    private static final Pattern URL_PATTERN = Pattern.compile("^/([0-9_]*)/");

    private P4DepotPath(URI uri) {
        this.depotPath = uri.getPath();
        Matcher matcher = URL_PATTERN.matcher(this.depotPath);
        if (matcher.find()) {
            String additionalPathElement = matcher.group(1);
            if (!additionalPathElement.isEmpty()) {
                log.debug("Additional path element: {} found in uri: {}. ", (Object)additionalPathElement, (Object)uri);
            }
            this.depotPath = "//" + matcher.replaceFirst("");
        }
    }

    public String getPath() {
        return this.depotPath;
    }

    public String getExPath() {
        return P4Utils.expandWildcards(this.depotPath);
    }

    public List<IFileSpec> createFileSpecs() {
        return FileSpecBuilder.makeFileSpecList((String[])new String[]{this.depotPath});
    }

    public List<IFileSpec> createExFileSpecs(String wildcard) {
        String expandedPath = P4Utils.expandWildcards(this.depotPath);
        return FileSpecBuilder.makeFileSpecList((String[])new String[]{expandedPath + wildcard});
    }

    public List<IFileSpec> createExFileSpecs() {
        return this.createExFileSpecs("");
    }

    public static P4DepotPath of(URI uri) {
        return new P4DepotPath(uri);
    }

    public boolean isRoot() {
        return this.depotPath.isEmpty();
    }

    public String toString() {
        return "P4DepotPath(depotPath=" + this.depotPath + ")";
    }
}

