/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.Configuration;
import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.oxygenxml.perforce.p4operations.P4Server;
import com.oxygenxml.perforce.p4operations.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.core.ChangelistStatus;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.option.client.RevertFilesOptions;
import com.perforce.p4java.option.client.ShelveFilesOptions;
import com.perforce.p4java.option.server.GetDepotFilesOptions;
import com.perforce.p4java.option.server.GetFileContentsOptions;
import com.perforce.p4java.option.server.OpenedFilesOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P4Client {
    private static final Logger log = LoggerFactory.getLogger(P4Client.class);
    private IOptionsServer server;
    private IClient client;
    private Configuration configuration;

    public P4Client(P4Server p4Server, Configuration configuration) throws ConnectionException, RequestException, AccessException {
        this.init(p4Server);
        this.server.createClient(this.client);
        this.server.setCurrentClient(this.client);
        this.configuration = configuration;
    }

    public P4Client(P4Server server, String dst, Configuration configuration) throws P4OperationException {
        this.configuration = configuration;
        this.init(server);
        Path rootDir = this.createTemporaryRoot();
        this.client.setRoot(rootDir.toString());
        this.setupView(dst);
    }

    public P4Client(P4Server server, String rootDir, String depotPath) throws P4OperationException {
        this.init(server);
        this.client.setRoot(rootDir);
        this.setupView(depotPath);
    }

    private Path createTemporaryRoot() {
        File tempDir = this.configuration.getPluginHomeDir();
        return tempDir.toPath().resolve(this.client.getName());
    }

    private void setupView(String depotPath) throws P4OperationException {
        try {
            ClientView view = new ClientView();
            String expandedPath = P4Utils.expandWildcards(depotPath);
            String depoSpec = "//" + this.client.getName() + expandedPath.substring(1);
            view.addEntry((IMapEntry)new ClientView.ClientViewMapping(0, expandedPath, depoSpec));
            this.client.setClientView(view);
            this.server.createClient(this.client);
            this.server.setCurrentClient(this.client);
        }
        catch (AccessException | ConnectionException | RequestException e) {
            throw new P4OperationException(e.getMessage(), e);
        }
    }

    private void init(P4Server p4Server) {
        this.server = p4Server.unwrap();
        String userName = this.server.getUserName();
        String clientName = this.getClientName();
        this.client = new Client((IServer)this.server);
        this.client.setName(clientName);
        this.client.setOwnerName(userName);
        this.client.setServer((IServer)this.server);
        this.client.setLineEnd(IClientSummary.ClientLineEnd.SHARE);
    }

    public String getClientName() {
        return "XMLWebAuthor_" + this.server.getUserName();
    }

    public IChangelist createNewChangelist(String description) throws P4OperationException {
        String p4User = this.server.getUserName();
        Changelist changeListImpl = new Changelist(-1, this.client.getName(), p4User, ChangelistStatus.NEW, new Date(), description, false, (Server)this.server);
        try {
            return this.client.createChangelist((IChangelist)changeListImpl);
        }
        catch (AccessException | ConnectionException | RequestException e) {
            throw new P4OperationException(e.getMessage(), e);
        }
    }

    IChangelist createNewChangelist() {
        return this.createNewChangelist("Checked out by WebAuthor");
    }

    public Optional<IChangelist> getLastPendingChangelist(List<IFileSpec> fileSpecs) throws P4OperationException {
        try {
            String clientName = this.getClientName();
            List summary = this.server.getChangelists(1, fileSpecs, clientName, this.server.getUserName(), true, IChangelist.Type.PENDING, true);
            if (summary.isEmpty()) {
                return Optional.empty();
            }
            int chListId = ((IChangelistSummary)summary.get(0)).getId();
            IChangelist changelist = this.server.getChangelist(chListId);
            log.debug("Found PENDING changelist: {} for file: {}", (Object)chListId, fileSpecs);
            return Optional.of(changelist);
        }
        catch (AccessException | ConnectionException | RequestException e) {
            throw new P4OperationException(e.getMessage(), e);
        }
    }

    public void revertAllOpenedFiles() throws P4JavaException {
        OpenedFilesOptions ofo = new OpenedFilesOptions(new String[]{"-C", this.client.getName()});
        List openedFiles = this.client.openedFiles(null, ofo);
        if (openedFiles.isEmpty()) {
            log.info("Nothing to revert for client {}", (Object)this);
        } else {
            RevertFilesOptions rfo = new RevertFilesOptions(new String[]{"-k"});
            List revertedFiles = this.client.revertFiles(openedFiles, rfo);
            log.info("Reverted files {} for client {}", (Object)revertedFiles, (Object)this);
        }
    }

    public List<IFileSpec> shelve(List<IFileSpec> fileSpecs, int changelistId, String ... shelveOptions) throws P4OperationException {
        try {
            return this.client.shelveFiles(fileSpecs, changelistId, new ShelveFilesOptions(shelveOptions));
        }
        catch (P4JavaException e) {
            log.error("Cannot execute shelve operation for:{} changeList:{} options:{}", new Object[]{fileSpecs, changelistId, shelveOptions, e});
            throw new P4OperationException("Cannot execute shelve operation for " + fileSpecs + " changelist: " + changelistId, e);
        }
    }

    public void deletePendingChangelist(int changelistId) throws P4OperationException {
        try {
            String opResult = this.server.deletePendingChangelist(changelistId);
            log.debug("Delete changelistId:{} result:{}", (Object)changelistId, (Object)opResult);
        }
        catch (AccessException | ConnectionException | RequestException e) {
            log.error("Cannot deleted pending changelist {}", (Object)changelistId, (Object)e);
            throw new P4OperationException("Cannot deleted pending changelist " + changelistId, e);
        }
    }

    public InputStream getFileContents(List<IFileSpec> fileSpecs, GetFileContentsOptions options) throws P4OperationException {
        try {
            return this.server.getFileContents(fileSpecs, options);
        }
        catch (P4JavaException e) {
            log.error("Cannot get file contents {}", fileSpecs, (Object)e);
            throw new P4OperationException("Error gettting content of: " + fileSpecs + ". " + e.getMessage(), e);
        }
    }

    List<IFileSpec> getDepotFiles(List<IFileSpec> fileSpecs, String ... options) {
        try {
            return this.server.getDepotFiles(fileSpecs, new GetDepotFilesOptions(options));
        }
        catch (P4JavaException e) {
            log.error("Cannot get files in changelist {}", fileSpecs);
            throw new P4OperationException("Cannot get files in changelist " + fileSpecs, e);
        }
    }

    public IClient unwrap() {
        return this.client;
    }

    public String toString() {
        return "Workspace:" + this.client.getName() + " - owner:" + this.client.getOwnerName();
    }
}

