/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.p4operations.P4Client;
import com.oxygenxml.perforce.p4operations.P4DepotPath;
import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.oxygenxml.perforce.p4operations.P4Utils;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P4CheckoutOperation {
    private static final Logger log = LoggerFactory.getLogger(P4CheckoutOperation.class);
    private Integer changelistId;

    public P4CheckoutOperation(Integer changelistId) {
        this.changelistId = changelistId;
    }

    public Void executeToChangelist(P4Client p4Client, P4DepotPath p4DepotPath) throws P4OperationException, P4JavaException {
        List<IFileSpec> fileList = p4DepotPath.createExFileSpecs();
        IClient client = p4Client.unwrap();
        client.sync(fileList, false, false, true, false);
        log.debug("client {} sync-ed", (Object)p4Client.getClientName());
        List specs = client.editFiles(fileList, false, false, this.changelistId.intValue(), null);
        P4Utils.validateFileSpecs(specs);
        return null;
    }

    public static Integer execute(P4Client p4Client, P4DepotPath p4DepotPath) throws P4OperationException, P4JavaException {
        IChangelist chlist = p4Client.createNewChangelist();
        new P4CheckoutOperation(chlist.getId()).executeToChangelist(p4Client, p4DepotPath);
        return chlist.getId();
    }
}

