/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce.p4operations;

import com.oxygenxml.perforce.p4operations.P4Client;
import com.oxygenxml.perforce.p4operations.P4DepotPath;
import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.file.IFileSpec;
import java.util.List;
import java.util.Optional;

public class P4ChangelistOperation {
    private Integer changelistId;

    public P4ChangelistOperation(Integer changelistId) {
        this.changelistId = changelistId;
    }

    public Void deleteChangelist(P4Client p4Client, P4DepotPath p4DepotPath) throws P4OperationException {
        p4Client.deletePendingChangelist(this.changelistId);
        return null;
    }

    public static Optional<IChangelist> getLastPendingChangelist(P4Client p4Client, P4DepotPath p4DepotPath) throws P4OperationException {
        List<IFileSpec> fileSpecs = p4DepotPath.createExFileSpecs();
        return p4Client.getLastPendingChangelist(fileSpecs);
    }

    public static Optional<Integer> getLastPendingChangelistId(P4Client p4Client, P4DepotPath p4DepotPath) throws P4OperationException {
        Optional<IChangelist> optChangelist = P4ChangelistOperation.getLastPendingChangelist(p4Client, p4DepotPath);
        return optChangelist.map(chlist -> chlist.getId());
    }

    public static Integer getLastPending(P4Client p4Client, P4DepotPath p4DepotPath) throws P4OperationException {
        Optional<IChangelist> optChangelist = P4ChangelistOperation.getLastPendingChangelist(p4Client, p4DepotPath);
        IChangelist changelist = optChangelist.orElseThrow(() -> new P4OperationException("No changelist found for path:" + p4DepotPath.getPath() + " client:" + p4Client.getClientName()));
        return changelist.getId();
    }
}

