/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce;

import java.util.concurrent.atomic.AtomicReference;
import ro.sync.exml.plugin.workspace.security.Response;
import ro.sync.exml.plugin.workspace.security.TrustedHostsProviderExtension;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class TrustedHostsProvider
implements TrustedHostsProviderExtension {
    private AtomicReference<String> enforcedHostRef = new AtomicReference();

    public TrustedHostsProvider() {
        final WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        this.updateEnforcedHost(optionsStorage);
        optionsStorage.addOptionListener(new WSOptionListener("perforce.server_url"){

            public void optionValueChanged(WSOptionChangedEvent event) {
                TrustedHostsProvider.this.updateEnforcedHost(optionsStorage);
            }
        });
        optionsStorage.addOptionListener(new WSOptionListener("perforce.server_port"){

            public void optionValueChanged(WSOptionChangedEvent event) {
                TrustedHostsProvider.this.updateEnforcedHost(optionsStorage);
            }
        });
    }

    private synchronized void updateEnforcedHost(WSOptionsStorage optionsStorage) {
        this.enforcedHostRef.set(null);
        String host = optionsStorage.getOption("perforce.server_url", null);
        String port = optionsStorage.getOption("perforce.server_port", null);
        if (host != null && !host.isEmpty() && port != null && !port.isEmpty()) {
            this.enforcedHostRef.set(host + ":" + port);
        }
    }

    public Response isTrusted(String hostName) {
        String enforcedHost = this.enforcedHostRef.get();
        if (hostName.equals(enforcedHost)) {
            return TRUSTED;
        }
        return UNKNOWN;
    }
}

