/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce;

import com.oxygenxml.perforce.Configuration;
import java.io.File;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletContext;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.exml.plugin.PluginContext;

public class SetupServlet
extends ServletPluginExtension {
    private static final Logger log = LoggerFactory.getLogger(SetupServlet.class);
    @PluginContext
    private Configuration configuration;

    public void init() throws ServletException {
        ServletContext servletContext = this.getServletConfig().getServletContext();
        if (log.isDebugEnabled()) {
            log.debug("System variables:");
            System.getProperties().keySet().stream().map(Object::toString).forEach(key -> log.debug("{}: {}", key, (Object)System.getProperty(key)));
            Collections.list(servletContext.getAttributeNames()).stream().forEach(name -> log.debug("{}:{}", name, servletContext.getAttribute(name)));
        }
        File webappDataDir = (File)servletContext.getAttribute("OXYGEN_WEBAPP_DATA_DIR");
        File rootDir = new File(webappDataDir, "perforce-data-dir");
        this.configuration.setPluginHomeDir(rootDir);
        boolean p4Ssl = Boolean.parseBoolean(System.getProperty("p4.ssl"));
        this.configuration.setP4Ssl(p4Ssl);
        log.info("Plugin home dir:{}", (Object)rootDir);
    }

    public String getPath() {
        return "p4setup";
    }
}

