/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce;

import com.oxygenxml.perforce.Configuration;
import com.oxygenxml.perforce.CredentialsStore;
import com.oxygenxml.perforce.p4operations.P4ChangelistOperation;
import com.oxygenxml.perforce.p4operations.P4OperationTemplate;
import com.oxygenxml.perforce.p4operations.P4RevertOperation;
import com.oxygenxml.perforce.p4operations.ShelfOperation;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationWithCustomUndoBehavior;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.operations.ReloadContentOperation;
import ro.sync.exml.plugin.PluginContext;

@WebappRestSafe
public class RevertOperation
extends AuthorOperationWithResult
implements AuthorOperationWithCustomUndoBehavior {
    private static final Logger log = LoggerFactory.getLogger(RevertOperation.class);
    @PluginContext
    private Configuration configuration;

    public String doOperation(AuthorDocumentModel model, ArgumentsMap args) throws AuthorOperationException {
        String result = "success";
        AuthorEditorAccess editorAccess = model.getAuthorAccess().getEditorAccess();
        URL url = editorAccess.getEditorLocation();
        String contextId = url.getUserInfo();
        PasswordAuthentication pa = CredentialsStore.getCredentials(contextId, url);
        try {
            URI uri = new URI(url.toString());
            P4OperationTemplate<Object> tmpl = new P4OperationTemplate<Object>(uri, pa, this.configuration);
            Integer changelistId = (Integer)tmpl.call(P4ChangelistOperation::getLastPending);
            tmpl.call(P4RevertOperation::execute);
            tmpl.call(new ShelfOperation(changelistId)::deleteFiles);
            tmpl.call(new P4ChangelistOperation(changelistId)::deleteChangelist);
            this.reloadDocument(model.getAuthorAccess());
            editorAccess.setModified(false);
        }
        catch (Exception e) {
            log.error("Could not revert file:{} - user:{}", new Object[]{url, pa.getUserName(), e});
            result = "failed";
        }
        return result;
    }

    void reloadDocument(AuthorAccess authorAccess) throws AuthorOperationException {
        new ReloadContentOperation().doOperation(authorAccess, argumentName -> argumentName.equals("markAsNotModified") ? "true" : "");
    }

    public RevertOperation(Configuration configuration) {
        this.configuration = configuration;
    }

    public RevertOperation() {
    }
}

