/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce;

import com.oxygenxml.perforce.Configuration;
import com.oxygenxml.perforce.CredentialsStore;
import com.oxygenxml.perforce.PerforceUrlConnection;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.WebappMessage;
import ro.sync.ecss.extensions.api.webapp.plugin.URLStreamHandlerWithContext;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;

public class PerforceUrlStreamHandler
extends URLStreamHandlerWithContext {
    private static final Logger log = LoggerFactory.getLogger(PerforceUrlStreamHandler.class);
    private Configuration configuration;

    protected URLConnection openConnectionInContext(String contextId, URL url, Proxy proxy) throws IOException {
        log.debug("creating connection for contextId:{} url:{}", (Object)contextId, (Object)url);
        PasswordAuthentication userCredentials = CredentialsStore.getCredentials(contextId, url);
        if (userCredentials == null) {
            throw new UserActionRequiredException(new WebappMessage(3, "Authentication required", url.toExternalForm(), true));
        }
        log.debug("userCredentials: {} ", (Object)userCredentials.getUserName());
        URLConnection p4connection = new URLConnection(url){

            @Override
            public void connect() throws IOException {
                log.debug("Connect to: {}", (Object)this.getURL());
            }
        };
        return new PerforceUrlConnection(p4connection, userCredentials, this.configuration);
    }

    public PerforceUrlStreamHandler(Configuration configuration) {
        this.configuration = configuration;
    }
}

