/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce;

import com.oxygenxml.perforce.Configuration;
import com.oxygenxml.perforce.p4operations.P4FileListOperation;
import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.oxygenxml.perforce.p4operations.P4PermissionException;
import com.oxygenxml.perforce.p4operations.P4ReadOperation;
import com.oxygenxml.perforce.p4operations.P4ShelveOperation;
import com.oxygenxml.perforce.p4operations.P4SubmitShelvedOperation;
import com.oxygenxml.perforce.p4operations.P4WriteOperation;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.plugin.FilterURLConnection;
import ro.sync.net.protocol.FolderEntryDescriptor;

public class PerforceUrlConnection
extends FilterURLConnection {
    private static final Logger log = LoggerFactory.getLogger(PerforceUrlConnection.class);
    private Configuration configuration;
    public static final String MESSAGE_PROPERTY_KEY = "MSG_KEY";
    public static final String SAVE_OPERATION_TYPE = "SAVE_TYPE";
    private PasswordAuthentication credentials;

    public PerforceUrlConnection(URLConnection delegateConnection, PasswordAuthentication credentials, Configuration configuration) {
        super(delegateConnection);
        this.credentials = credentials;
        this.configuration = configuration;
    }

    public InputStream getInputStream() throws IOException {
        log.debug("input stream to {}", (Object)this.url);
        try {
            log.debug("Reading url: {} user: {} - pass: {}", new Object[]{this.url, this.credentials.getUserName(), this.credentials.getPassword()});
            P4ReadOperation readOp = new P4ReadOperation(new URI(this.url.toString()), this.credentials, this.configuration);
            return readOp.read();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error streaming from url:" + this.url, (Throwable)e);
            throw new IOException(e.getCause().getMessage(), e);
        }
    }

    public List<FolderEntryDescriptor> listFolder() throws IOException {
        List<FolderEntryDescriptor> folderEntryDescriptorList = new ArrayList<FolderEntryDescriptor>();
        try {
            P4FileListOperation readOp = new P4FileListOperation(new URI(this.url.toString()), this.credentials, this.configuration);
            folderEntryDescriptorList = readOp.getFolderEntryDescriptorList();
        }
        catch (Exception e) {
            log.error("Exception reading folder: ", (Throwable)e);
        }
        return folderEntryDescriptorList;
    }

    public OutputStream getOutputStream() throws IOException {
        log.debug("output stream from {}", (Object)this.url);
        final String message = this.getChangelistDescription();
        final String saveOperationType = this.getRequestProperty(SAVE_OPERATION_TYPE);
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                byte[] fileContents = this.toByteArray();
                try {
                    if ("shelve".equals(saveOperationType)) {
                        P4ShelveOperation shelveOp = new P4ShelveOperation(PerforceUrlConnection.this.url.toURI(), PerforceUrlConnection.this.credentials, PerforceUrlConnection.this.configuration);
                        shelveOp.execute(fileContents);
                    } else if ("submitShelved".equals(saveOperationType)) {
                        P4SubmitShelvedOperation submitShelvedOp = new P4SubmitShelvedOperation(PerforceUrlConnection.this.url.toURI(), PerforceUrlConnection.this.credentials, message, PerforceUrlConnection.this.configuration);
                        submitShelvedOp.execute(fileContents);
                    } else {
                        P4WriteOperation writeOp = new P4WriteOperation(PerforceUrlConnection.this.url.toURI(), PerforceUrlConnection.this.credentials, "Submitted by WebAuthor", PerforceUrlConnection.this.configuration);
                        writeOp.write(fileContents);
                    }
                }
                catch (P4OperationException | P4PermissionException | URISyntaxException e) {
                    throw new IOException(e.getMessage(), e);
                }
                super.close();
            }
        };
    }

    private String getChangelistDescription() {
        String message = this.getRequestProperty(MESSAGE_PROPERTY_KEY);
        if (message == null) {
            message = "Submitted from Oxygen XML Web Author";
        }
        return message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PerforceUrlConnection)) {
            return false;
        }
        PerforceUrlConnection other = (PerforceUrlConnection)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Configuration this$configuration = this.configuration;
        Configuration other$configuration = other.configuration;
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        PasswordAuthentication this$credentials = this.credentials;
        PasswordAuthentication other$credentials = other.credentials;
        return !(this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PerforceUrlConnection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Configuration $configuration = this.configuration;
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        PasswordAuthentication $credentials = this.credentials;
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        return result;
    }
}

