/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce;

import com.oxygenxml.perforce.Configuration;
import com.oxygenxml.perforce.CredentialsStore;
import com.oxygenxml.perforce.p4operations.P4Client;
import com.oxygenxml.perforce.p4operations.P4PermissionException;
import com.oxygenxml.perforce.p4operations.P4Server;
import com.oxygenxml.perforce.p4operations.UntrustedHostException;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;
import ro.sync.exml.plugin.PluginContext;

public class P4LoginServlet
extends ServletPluginExtension {
    private static final Logger log = LoggerFactory.getLogger(P4LoginServlet.class);
    @PluginContext
    private Configuration configuration;

    public void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        String sessionId = httpRequest.getSession().getId();
        String action = httpRequest.getParameter("action");
        String serverUrl = httpRequest.getParameter("server");
        log.debug("Requested action:{}", (Object)action);
        this.logParameters(httpRequest);
        if ("logout".equals(action)) {
            log.info("User with session:{} logged out for serverUrl:{}", (Object)sessionId, (Object)serverUrl);
            PasswordAuthentication pa = CredentialsStore.getCredentials(sessionId, serverUrl);
            try (P4Server server = new P4Server(new URI(serverUrl), pa, this.configuration);){
                server.connect();
                P4Client p4Client = new P4Client(server, this.configuration);
                p4Client.revertAllOpenedFiles();
            }
            catch (Exception e) {
                log.error("cannot revert", (Throwable)e);
            }
            CredentialsStore.invalidate(sessionId);
        } else {
            String user = httpRequest.getParameter("user");
            String password = httpRequest.getParameter("passwd");
            log.debug("Credentials submitted for session:{}, user:{}, passwd:{}, serverUrl:{}", new Object[]{sessionId, user, password, serverUrl});
            PasswordAuthentication pa = new PasswordAuthentication(user, password.toCharArray());
            try (P4Server server = new P4Server(new URI(serverUrl), pa, this.configuration);){
                server.connect();
                CredentialsStore.storeUser(serverUrl, sessionId, user, password);
                httpResponse.setStatus(202);
            }
            catch (P4PermissionException e) {
                log.debug("Could not login user: {} for serverUrl: {}", new Object[]{user, serverUrl, e});
                this.sendErrorMessage(httpResponse, e.getMessage());
            }
            catch (UntrustedHostException e) {
                log.warn("Connect to untrusted host: {} blocked for user: {}", new Object[]{serverUrl, user, e});
                this.sendErrorMessage(httpResponse, e.getMessage());
            }
            catch (Exception e) {
                log.debug("Error logging user: {} for serverUrl: {}", new Object[]{user, serverUrl, e});
                httpResponse.setStatus(500);
            }
        }
    }

    private void sendErrorMessage(HttpServletResponse httpResponse, String message) throws IOException {
        httpResponse.setStatus(403);
        httpResponse.setContentType("text/plain");
        httpResponse.getWriter().append(this.escapeMessage(message));
        httpResponse.getWriter().flush();
    }

    private String escapeMessage(String text) {
        BasicXmlUtil.EscapeSelectionOptions options = new BasicXmlUtil.EscapeSelectionOptions(true, false, true, false, false, false, false, false, 0, false, false);
        return BasicXmlUtil.escape((String)text, (BasicXmlUtil.EscapeSelectionOptions)options);
    }

    private void logParameters(HttpServletRequest httpRequest) {
        if (log.isDebugEnabled()) {
            Enumeration pnames = httpRequest.getParameterNames();
            while (pnames.hasMoreElements()) {
                String pname = (String)pnames.nextElement();
                log.debug("Request parameter: {} = {}", (Object)pname, (Object)httpRequest.getParameter(pname));
            }
        }
    }

    public String getPath() {
        return "p4login";
    }

    public P4LoginServlet(Configuration configuration) {
        this.configuration = configuration;
    }

    public P4LoginServlet() {
    }
}

