/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce;

import com.oxygenxml.perforce.Configuration;
import com.oxygenxml.perforce.CredentialsStore;
import com.oxygenxml.perforce.p4operations.P4ChangelistOperation;
import com.oxygenxml.perforce.p4operations.P4OperationTemplate;
import com.oxygenxml.perforce.p4operations.P4RevertOperation;
import com.oxygenxml.perforce.p4operations.P4VoidOperation;
import com.oxygenxml.perforce.p4operations.ShelfOperation;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.plugin.LockHandlerWithContext;
import ro.sync.exml.plugin.lock.LockException;

public class P4LockHandler
extends LockHandlerWithContext {
    private static final Logger log = LoggerFactory.getLogger(P4LockHandler.class);
    private Configuration configuration;

    public boolean isSaveAllowed(String contextId, URL url, int timeoutSeconds) {
        throw new IllegalStateException("isSaveAllowed should not be called");
    }

    public void unlock(String contextId, URL resource) throws LockException {
        PasswordAuthentication pa = CredentialsStore.getCredentials(contextId, resource);
        if (pa != null) {
            try {
                log.debug("Revert and unlock file {} - user:{}", (Object)resource);
                URI uri = new URI(resource.toString());
                Optional optChangelistId = P4OperationTemplate.create(uri, pa, this.configuration).call(P4ChangelistOperation::getLastPendingChangelistId);
                if (optChangelistId.isPresent()) {
                    P4VoidOperation tmpl = new P4VoidOperation(uri, pa, this.configuration);
                    tmpl.call(P4RevertOperation::execute);
                    Optional id = P4OperationTemplate.create(uri, pa, this.configuration).call(ShelfOperation::getChangelistId);
                    if (!id.isPresent()) {
                        tmpl.call(new P4ChangelistOperation((Integer)optChangelistId.get())::deleteChangelist);
                    }
                }
            }
            catch (Exception e) {
                log.error("Could not create unlock operation for {} and user {}", new Object[]{resource, pa.getUserName(), e});
                throw new LockException("Could not create unlock operation", false, "Could not create unlock operation  " + resource + " for user " + pa.getUserName());
            }
        }
    }

    public void updateLock(String contextId, URL resource, int timeoutSeconds) throws LockException {
    }

    public boolean isLockEnabled() {
        return true;
    }

    public P4LockHandler(Configuration configuration) {
        this.configuration = configuration;
    }
}

