/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialsStore {
    private static final Logger log = LoggerFactory.getLogger(CredentialsStore.class);
    private static final int CREDENTIALS_CACHE_CONCURRENCY_LEVEL = 10;
    private static final int CREDENTIALS_MAXIMUM_SIZE = 10000;
    private static final Cache<String, Map<String, PasswordAuthentication>> CREDENTIALS = CacheBuilder.newBuilder().concurrencyLevel(10).maximumSize(10000L).build();

    public static String computeServerId(String serverUrl) {
        String serverId = null;
        try {
            URL url = new URL(serverUrl);
            serverId = url.getProtocol() + url.getHost() + url.getPort();
        }
        catch (MalformedURLException e) {
            log.error("Invalid serverUrl:{}", (Object)serverUrl, (Object)e);
            throw new IllegalArgumentException("Invalid serverUrl:" + serverUrl, e);
        }
        log.debug("Compputed serverID: {} for serverUrl:{}", (Object)serverId, (Object)serverUrl);
        return serverId;
    }

    public static PasswordAuthentication getCredentials(String contextId, URL serverUrl) {
        return CredentialsStore.getCredentials(contextId, serverUrl.toExternalForm());
    }

    public static PasswordAuthentication getCredentials(String contextId, String serverUrl) {
        PasswordAuthentication userCredentials = null;
        Map credentialsMap = (Map)CREDENTIALS.getIfPresent((Object)contextId);
        if (credentialsMap != null) {
            userCredentials = (PasswordAuthentication)credentialsMap.get(CredentialsStore.computeServerId(serverUrl));
            if (log.isDebugEnabled()) {
                credentialsMap.keySet().forEach(key -> log.debug("Key in map:" + key));
            }
        }
        return userCredentials;
    }

    public static void invalidate(String sessionId) {
        CREDENTIALS.invalidate((Object)sessionId);
    }

    public static void storeUser(String serverUrl, String contextId, String username, String password) {
        HashMap<String, PasswordAuthentication> userCredentialsMap = (HashMap<String, PasswordAuthentication>)CREDENTIALS.getIfPresent((Object)contextId);
        if (userCredentialsMap == null) {
            userCredentialsMap = new HashMap<String, PasswordAuthentication>();
            CREDENTIALS.put((Object)contextId, userCredentialsMap);
        }
        String key = CredentialsStore.computeServerId(serverUrl);
        userCredentialsMap.put(key, new PasswordAuthentication(username, password.toCharArray()));
    }
}

