/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce;

import com.oxygenxml.perforce.Configuration;
import com.oxygenxml.perforce.CredentialsStore;
import com.oxygenxml.perforce.p4operations.P4ChangelistOperation;
import com.oxygenxml.perforce.p4operations.P4CheckoutOperation;
import com.oxygenxml.perforce.p4operations.P4LockOperation;
import com.oxygenxml.perforce.p4operations.P4OperationException;
import com.oxygenxml.perforce.p4operations.P4OperationTemplate;
import com.oxygenxml.perforce.p4operations.ShelfOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationWithCustomUndoBehavior;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.operations.ReloadContentOperation;
import ro.sync.exml.plugin.PluginContext;
import ro.sync.exml.plugin.lock.LockException;

@WebappRestSafe
public class CheckoutOperation
extends AuthorOperationWithResult
implements AuthorOperationWithCustomUndoBehavior {
    private static final Logger log = LoggerFactory.getLogger(CheckoutOperation.class);
    @PluginContext
    private Configuration configuration;
    public static final String SUCCESS_OPERATION_RESULT = "success";

    public String doOperation(AuthorDocumentModel model, ArgumentsMap args) throws AuthorOperationException {
        String result = SUCCESS_OPERATION_RESULT;
        AuthorEditorAccess editorAccess = model.getAuthorAccess().getEditorAccess();
        URL url = editorAccess.getEditorLocation();
        String contextId = url.getUserInfo();
        PasswordAuthentication pa = CredentialsStore.getCredentials(contextId, url);
        try {
            String operationType = (String)args.getArgumentValue("checkoutType");
            URI uri = new URI(url.toString());
            if ("shelveCheckout".equals(operationType)) {
                P4OperationTemplate<Integer> intTmpl = new P4OperationTemplate<Integer>(uri, pa, this.configuration);
                Integer changelistId = intTmpl.call(P4ChangelistOperation::getLastPending);
                P4OperationTemplate<Void> checkoutTmpl = new P4OperationTemplate<Void>(uri, pa, this.configuration);
                checkoutTmpl.call(new P4CheckoutOperation(changelistId)::executeToChangelist);
                checkoutTmpl.call(new P4LockOperation()::execute);
                log.debug("READING SHELVED {}", (Object)url);
                P4OperationTemplate<InputStream> tmpl = new P4OperationTemplate<InputStream>(uri, pa, this.configuration);
                InputStream is = tmpl.call(new ShelfOperation(changelistId)::readFiles);
                InputStreamReader targetReader = new InputStreamReader(is, "UTF-8");
                editorAccess.reloadContent((Reader)targetReader);
                ((Reader)targetReader).close();
            } else {
                P4OperationTemplate<Object> tmpl = new P4OperationTemplate<Object>(uri, pa, this.configuration);
                tmpl.call(P4CheckoutOperation::execute);
                tmpl.call(new P4LockOperation()::execute);
                this.reloadDocument(model.getAuthorAccess());
            }
            model.getAuthorDocumentController().getUndoManager().discardAllEdits();
        }
        catch (P4OperationException | UnsupportedEncodingException | URISyntaxException | LockException e) {
            log.error("Error checking out URL:{} user:{}", new Object[]{url, pa.getUserName(), e});
            result = e.getMessage();
        }
        catch (IOException e) {
            log.error("Error checking out URL:{} user: {}", new Object[]{url, pa.getUserName(), e});
        }
        return result;
    }

    void reloadDocument(AuthorAccess authorAccess) throws AuthorOperationException {
        new ReloadContentOperation().doOperation(authorAccess, argumentName -> "markAsNotModified".equals(argumentName) ? "true" : "");
    }

    public CheckoutOperation(Configuration configuration) {
        this.configuration = configuration;
    }

    public CheckoutOperation() {
    }
}

