/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.perforce;

import com.oxygenxml.perforce.Configuration;
import com.oxygenxml.perforce.CredentialsStore;
import com.oxygenxml.perforce.p4operations.P4OperationTemplate;
import com.oxygenxml.perforce.p4operations.ShelfOperation;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.exml.plugin.PluginContext;

@WebappRestSafe
public class CheckShelfOperation
extends AuthorOperationWithResult {
    private static final Logger log = LoggerFactory.getLogger(CheckShelfOperation.class);
    @PluginContext
    private Configuration configuration;

    public String doOperation(AuthorDocumentModel model, ArgumentsMap args) throws AuthorOperationException {
        AuthorEditorAccess editorAccess = model.getAuthorAccess().getEditorAccess();
        URL url = editorAccess.getEditorLocation();
        String contextId = url.getUserInfo();
        PasswordAuthentication pa = CredentialsStore.getCredentials(contextId, url);
        try {
            P4OperationTemplate<Optional> tmpl = new P4OperationTemplate<Optional>(new URI(url.toString()), pa, this.configuration);
            Optional optChlId = tmpl.call(ShelfOperation::getChangelistId);
            return String.valueOf(optChlId.orElse(-1));
        }
        catch (Exception e) {
            log.error("Could not revert document at:{} user:{}", new Object[]{url, pa.getUserName(), e});
            String result = "failed";
            return result;
        }
    }

    public CheckShelfOperation(Configuration configuration) {
        this.configuration = configuration;
    }

    public CheckShelfOperation() {
    }
}

